package org.lsst.ccs.subsystem.power.constants;

import org.lsst.ccs.bus.data.Alert;

/**
 * Quadbox Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum QuadboxAlerts {

    PDU_ALERT("PduAlert", "Alert on PDU channel");
        
    private final String id, description;
    
    QuadboxAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId(String channel) {
        return id + "/" + channel;
    }
    
    public String getDescription(String channel) {
        return description;
    }
    
    public Alert newAlert(String channel) {
        return new Alert(getId(channel), getDescription(channel));
    }
    
}
