package org.lsst.ccs.subsystem.power.constants;

import org.lsst.ccs.drivers.auxelex.RebPS;

/**
 * Enumeration for REB power supply elements
 * 
 * @author  Owen Saxton
 */
public enum RebPsEnum {

    MASTER(-1),
    DIGITAL(RebPS.PS_DIGITAL),
    ANALOG(RebPS.PS_ANALOG),
    OD(RebPS.PS_OD),
    CLOCKHI(RebPS.PS_CLK_HIGH),
    CLOCKLO(RebPS.PS_CLK_LOW),
    HEATER(RebPS.PS_HEATER),
    DPHI(RebPS.PS_DPHI),
    HVBIAS(RebPS.PS_HV_BIAS);

    int number;

    RebPsEnum(int number) {
        this.number = number;
    }

    public int getNumber() {
        return number;
    }

}
