package org.lsst.ccs.subsystem.power.states;

/**
 * Power State for all the Rebs.
 * State transitions are defined based on the configuration parameters stored in
 * variable "powerStateTransitionLimits" in the RebPower class. This array defines
 * the boundaries between the states.
 * 
 * @author The LSST CCS Team
 */
public enum RebPowerState {

    /**
     * The initial power state or when the device cannot be read.
     */
    UNKNOWN,

    /**
     * It indicates that the Power Supply channel for this Reb has tripped.
     */
    TRIPPED,

    /**
     * Power per Reb is below the lower limit.
     */
    OFF,
    
    /**
     * Power per Reb is at the first level.
     */
    ON,
    
    /**
     * Power per Reb is at the second level.
     */
    LOW_POWER,
    
    /**
     * Power per Reb is above the third level.
     */
    OPERATIONAL,
    
}
