package org.lsst.ccs.subsystem.power.data;
import org.lsst.ccs.subsystem.power.data.RebPsState;
//import org.lsst.ccs.subsystem.power.RebPowerSupplyNode;

/**
 *  REB HV Bias information per REB
 *   - based on hvbiasdict from the HV bias regulation py script
 *  @author CCS Team
 */
public class RebHVBiasInfo {


    Object target = null;
    boolean state = false;
    double setpt = 0.0;
    boolean enable = false;
    double volts = 0.0;
    double lastVolts = 0.0;
    double current = 0.0;
    double lastCurrent = 0.0;
    int dac = 0;
    int lastDac = 0;
    int firstDac = 0;
    int maxDac = 0;
    double voltsPerStep = 0.125;
    
    /**
     *  Constructor.
     */
    public RebHVBiasInfo(Object target, boolean state, double setpt, boolean enable, double volts, double lastVolts, double current, double lastCurrent, int dac, int lastDac, double voltsPerStep, int firstDac, int maxDac)
   {
        this.target = target;
        this.state  = state;
        this.setpt  = setpt;
        this.enable = enable;
        this.volts  = volts;
        this.lastVolts  = lastVolts;
        this.current     = current;
        this.lastCurrent    = lastCurrent;
        this.dac         = dac;
        this.lastDac    = lastDac;
        this.voltsPerStep = voltsPerStep;
        this.firstDac = firstDac;  // initial step targetting ~4V
        this.maxDac = maxDac;  // max allowed value targetting setpt+2
    }

    // getter methods
    public Object getTarget()  {return target;}
    public boolean getState() {return state;}
    public double getSetPt()  {return setpt;}
    public boolean getEnable(){return enable;}
    public double getVolts()  {return volts;}
    public double getLastVolts()  {return lastVolts;}
    public double getCurrent(){return current;}
    public double getLastCurrent(){return lastCurrent;}
    public int getDac()    {return dac;}
    public int getLastDac(){return lastDac;}
    public double getVoltsPerStep(){return voltsPerStep;}
    public int getFirstDac(){return firstDac;}
    public int getMaxDac(){return maxDac;}

    // setter methods
    public void setTarget(Object inTarget)  {target = inTarget;}
    public void setState(boolean inState) {state = inState;}
    public void setSetPt(double inSetPt)  {setpt = inSetPt;}
    public void setEnable(boolean inEnable){enable = inEnable;}
    public void setVolts(double inVolts)  {volts = inVolts;}
    public void setLastVolts(double inLastVolts)  {lastVolts = inLastVolts;}
    public void setCurrent(double inCurrent){current = inCurrent;}
    public void setLastCurrent(double inLastCurrent){lastCurrent = inLastCurrent;}
    public void setDac(int inDac)    {dac = inDac;}
    public void setLastDac(int inLastDac){lastDac = inLastDac;}
    public void setVoltsPerStep(double inVoltsPerStep){voltsPerStep = inVoltsPerStep;}
    public void setFirstDac(int inFirstDac)    {firstDac = inFirstDac;}
    public void setDacN(int inMaxDac)    {maxDac = inMaxDac;}
    
}
