package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 *  Contains the state of an ATS power supply subsystem
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class ATSPowerState implements Serializable {
    
    public static final String KEY = "ATSPowerState";

    private final int tickMillis;         // Data status update period (ms)
    private final Boolean[] powerState;
    private final double hvBias;
    private final double dphi;
    private final String tempChannel;
    private final boolean tempFanControl;
    private final double tempLimit;
    private final double tempValue;
 
    public ATSPowerState(int tickMillis, Boolean[] powerState, double dphi, double hvBias, String tempChannel,
                         boolean tempFanControl, double tempLimit, double tempValue)
    {
        this.tickMillis = tickMillis;
        this.powerState = powerState;
        this.hvBias = hvBias;
        this.dphi = dphi;
        this.tempChannel = tempChannel;
        this.tempFanControl = tempFanControl;
        this.tempLimit = tempLimit;
        this.tempValue = tempValue;
    }
    
    public int getTickMillis()
    {
        return tickMillis;
    }

    public Boolean[] getPowerState()
    {
        return powerState;
    }

    public double getHvBias()
    {
        return hvBias;
    }

    public double getDphi()
    {
        return dphi;
    }

    public String getTempChannel()
    {
        return tempChannel;
    }

    public boolean getTempFanControl()
    {
        return tempFanControl;
    }

    public double getTempLimit()
    {
        return tempLimit;
    }

    public double getTempValue()
    {
        return tempValue;
    }

    private static final long serialVersionUID = 101L;
}
