package org.lsst.ccs.subsystem.power.data;
import org.lsst.ccs.subsystem.power.data.RebPsState;
//import org.lsst.ccs.subsystem.power.RebPowerSupplyNode;

/**
 *  REB HV Bias information per REB
 *   - based on hvbiasdict from the HV bias regulation py script
 *  @author CCS Team
 */
public class RebHVBiasInfo {


    Object target = null;
    //    RebPsState state = null;
    boolean state = false;
    double setpt = 0.0;
    boolean enable = false;
    double volts = 0.0;
    double last_volts = 0.0;
    double current = 0.0;
    int dac = 0;
    int last_dac = 0;
    int delta_dac = 0;
    double delta_volts = 0.0;
    double volts_per_step0 = 0.125;
    double volts_per_step = volts_per_step0;

    
    /**
     *  Constructor.
     */
    public RebHVBiasInfo(Object target, boolean state, double setpt, boolean enable, double volts, double last_volts, double current, int dac, int last_dac, int delta_dac, double delta_volts, double volts_per_step)
   {
	
	this.target = target;
	this.state  = state;
	this.setpt  = setpt;
	this.enable = enable;
	this.volts  = volts;
	this.last_volts  = last_volts;
	this.current     = current;
	this.dac         = dac;
	this.last_dac    = last_dac;
	this.delta_dac   = delta_dac;
	this.delta_volts = delta_volts;
	this.volts_per_step = volts_per_step;
    }

    // getter methods
    public Object getTarget()  {return target;}
    public boolean getState() {return state;}
    public double getSetPt()  {return setpt;}
    public boolean getEnable(){return enable;}
    public double getVolts()  {return volts;}
    public double getLastVolts()  {return last_volts;}
    public double getCurrent(){return current;}
    public int getDac()    {return dac;}
    public double getLastDac(){return last_dac;}
    public double getDeltaDac(){return delta_dac;}
    public double getDeltaVolts(){return delta_volts;}
    public double getVoltsPerStep(){return volts_per_step;}

    // setter methods
    public void setTarget(Object inTarget)  {target = inTarget;}
    public void setState(boolean inState) {state = inState;}
    public void setSetPt(double inSetPt)  {setpt = inSetPt;}
    public void setEnable(boolean inEnable){enable = inEnable;}
    public void setVolts(double inVolts)  {volts = inVolts;}
    public void setLastVolts(double in_last_volts)  {last_volts = in_last_volts;}
    public void setCurrent(double inCurrent){current = inCurrent;}
    public void setDac(int inDac)    {dac = inDac;}
    public void setLastDac(int in_last_dac){last_dac = in_last_dac;}
    public void setDeltaDac(int in_delta_dac){delta_dac = in_delta_dac;}
    public void setDeltaVolts(double in_delta_volts){delta_volts = in_delta_volts;}
    public void setVoltsPerStep(double in_volts_per_step){volts_per_step = in_volts_per_step;}
    
}
