package org.lsst.ccs.subsystem.power.constants;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.BfrComCam;
import org.lsst.ccs.drivers.auxelex.ComCamPdu24VC;
import org.lsst.ccs.drivers.auxelex.ComCamPdu24VD;
import org.lsst.ccs.drivers.auxelex.ComCamPdu48V;
import org.lsst.ccs.drivers.auxelex.Pdu5V;
import org.lsst.ccs.drivers.auxelex.RebBulkPS;

/**
 * Quad box switch definitions.
 *
 * @author The CCS team
 */
public class ComCamQuadBoxSwitches {

    public static final int
        DEVC_BFR      = 0,
        DEVC_PDU_5V   = 1,
        DEVC_PDU_24VC = 2,
        DEVC_PDU_24VD = 3,
        DEVC_PDU_48V  = 4,
        DEVC_REB_BULK = 5, // not used and only present so that it can be ignored
        NUM_DEVICES   = 5;

    public static final int
	SW_RELAY_PTH_CMC_SCR_00 = BfrComCam.RELAY_PTH_CMC_SCR_00 + 256 * DEVC_BFR,
	SW_RELAY_PTH_CMC_SCR_00b = BfrComCam.RELAY_PTH_CMC_SCR_00b + 256 * DEVC_BFR,
	SW_RELAY_AUX_CMC_DPP_01 = BfrComCam.RELAY_AUX_CMC_DPP_01 + 256 * DEVC_BFR,
	SW_RELAY_PTH_CMC_SCR_01 = BfrComCam.RELAY_PTH_CMC_SCR_01 + 256 * DEVC_BFR,
	SW_RELAY_SHT_SHT_PSW_00 = BfrComCam.RELAY_SHT_SHT_PSW_00 + 256 * DEVC_BFR,
	SW_RELAY_VCR_CMC_PCT_00 = BfrComCam.RELAY_VCR_CMC_PCT_00 + 256 * DEVC_BFR,
	SW_RELAY_DPP_01 = BfrComCam.RELAY_DPP_01 + 256 * DEVC_BFR,
    //        SW_RELAY_HTR_1  = BfrComCam.RELAY_HTR_1 + 256 * DEVC_BFR,
    //        SW_RELAY_HTR_2  = BfrComCam.RELAY_HTR_2 + 256 * DEVC_BFR,
        SW_RELAY_PWS_2  = BfrComCam.RELAY_PWS_2 + 256 * DEVC_BFR,
        SW_RELAY_PWS_3  = BfrComCam.RELAY_PWS_3 + 256 * DEVC_BFR,
        SW_RELAY_PWS_4  = BfrComCam.RELAY_PWS_4 + 256 * DEVC_BFR,
        SW_RELAY_PWS_16 = BfrComCam.RELAY_PWS_16 + 256 * DEVC_BFR,
        SW_RELAY_PWS_17 = BfrComCam.RELAY_PWS_17 + 256 * DEVC_BFR,
        SW_RELAY_PWS_18 = BfrComCam.RELAY_PWS_18 + 256 * DEVC_BFR,
        SW_RELAY_PWS_19 = BfrComCam.RELAY_PWS_19 + 256 * DEVC_BFR,
        SW_RELAY_PWS_25 = BfrComCam.RELAY_PWS_25 + 256 * DEVC_BFR,
        SW_RELAY_PWS_20 = BfrComCam.RELAY_PWS_20 + 256 * DEVC_BFR,
        SW_RELAY_PWS_21 = BfrComCam.RELAY_PWS_21 + 256 * DEVC_BFR,
        SW_PDU_5V        = SW_RELAY_PWS_21,
        SW_PDU_24VC      = SW_RELAY_PWS_20,
        SW_PDU_24VD      = SW_RELAY_PWS_3,
        SW_PDU_48V       = SW_RELAY_PWS_2,
    //        SW_REB_BULK_PS_0 = SW_RELAY_PWS_16,
    //        SW_REB_BULK_PS_1 = SW_RELAY_PWS_17,
    //        SW_REB_BULK_PS_2 = SW_RELAY_PWS_18,
    //        SW_REB_BULK_PS_3 = SW_RELAY_PWS_19,
    //        SW_REB_BULK_PS_4 = SW_RELAY_PWS_25,
        SW_TRIM_HEATERS  = SW_RELAY_PWS_4;
    //        SW_HEATER_1      = SW_RELAY_HTR_1,
    //        SW_HEATER_2      = SW_RELAY_HTR_2;

    public static final int
        SW_OTM_3_A = Pdu5V.CHAN_OTM_3_A + 256 * DEVC_PDU_5V,
        SW_OTM_3_B = Pdu5V.CHAN_OTM_3_B + 256 * DEVC_PDU_5V;

    /*
        "ion pumps"                J5
        "v24cj6"               J6
        "open"        J7
        "bpuMaq20"        J8

        "v24cj9"              J9
        "PF MAQ20"           J10
        "gauges"           J11
        "v24cj12"           J12

        "bodyPurge"       J13
        "open"             J14
        "FESEncoder"       J15
        "hcuFesShu"        J16
    */

    public static final int
        SW_MAIN_24C      = 0xff + 256 * DEVC_PDU_24VC,
  
        SW_ION_PUMP      = ComCamPdu24VC.CHAN_J5 + 256 * DEVC_PDU_24VC,
    //        SW_J5            = ComCamPdu24VC.CHAN_J5 + 256 * DEVC_PDU_24VC,
        SW_J6            = ComCamPdu24VC.CHAN_J6 + 256 * DEVC_PDU_24VC,
        SW_J7            = ComCamPdu24VC.CHAN_J7 + 256 * DEVC_PDU_24VC,
        SW_J8            = ComCamPdu24VC.CHAN_J8 + 256 * DEVC_PDU_24VC,

        SW_J9            = ComCamPdu24VC.CHAN_J9 + 256 * DEVC_PDU_24VC,
        SW_BPU_MAQ20     = ComCamPdu24VC.CHAN_BPU_MAQ20 + 256 * DEVC_PDU_24VC,
        SW_GAUGES        = ComCamPdu24VC.CHAN_J11 + 256 * DEVC_PDU_24VC,
        SW_BODY_PURGE    = ComCamPdu24VC.CHAN_J12 + 256 * DEVC_PDU_24VC,

    //        SW_BODY_PURGE    = ComCamPdu24VC.CHAN_BODY_PURGE + 256 * DEVC_PDU_24VC,
    //        SW_GAUGES        = ComCamPdu24VC.CHAN_GAUGES + 256 * DEVC_PDU_24VC,
        SW_J13     = ComCamPdu24VC.CHAN_J13 + 256 * DEVC_PDU_24VC,
        SW_J14     = ComCamPdu24VC.CHAN_J14 + 256 * DEVC_PDU_24VC,
        SW_FES_ENCODER   = ComCamPdu24VC.CHAN_J15 + 256 * DEVC_PDU_24VC,
        SW_HCU_FES_SHU   = ComCamPdu24VC.CHAN_J16 + 256 * DEVC_PDU_24VC;

    public static final int
        SW_MAIN_24D      = 0xff + 256 * DEVC_PDU_24VD,
    //        SW_CRYO_TURBO    = ComCamPdu24VD.CHAN_CRYO_TURBO + 256 * DEVC_PDU_24VD,
        SW_PFTURBO       = ComCamPdu24VD.CHAN_PFTURBO + 256 * DEVC_PDU_24VD,
        SW_PFSCROLL      = ComCamPdu24VD.CHAN_PFSCROLL + 256 * DEVC_PDU_24VD,
        SW_FES           = ComCamPdu24VD.CHAN_FES + 256 * DEVC_PDU_24VD,
    //        SW_SHUTTER_BRAKE = ComCamPdu24VD.CHAN_SHUTTER_BRAKE + 256 * DEVC_PDU_24VD;
        SW_BOOSTER_PUMP  = ComCamPdu24VD.CHAN_BOOSTER_PUMP + 256 * DEVC_PDU_24VD;

    public static final int
        SW_MAIN_48        = 0xff + 256 * DEVC_PDU_48V,
        SW_CRYOTEL_CTRL0  = ComCamPdu48V.CHAN_CRYOTEL_CTRL0 + 256 * DEVC_PDU_48V,
        SW_CRYOTEL_CTRL1  = ComCamPdu48V.CHAN_CRYOTEL_CTRL1 + 256 * DEVC_PDU_48V,
        SW_CRYOTEL_CTRL2  = ComCamPdu48V.CHAN_CRYOTEL_CTRL2 + 256 * DEVC_PDU_48V,
        SW_PURGE_FAN      = ComCamPdu48V.CHAN_PURGE_FAN     + 256 * DEVC_PDU_48V,
        SW_REB_BULK_0     = ComCamPdu48V.CHAN_REB_BULK      + 256 * DEVC_PDU_48V;

    // For ComCam the REB Bulk has been moved to 48V Dirty  
    //    public static final int
    //        SW_REB_BULK_0 = 0 + 256 * DEVC_REB_BULK;

    public static final int[] NUM_SWITCHES = new int[NUM_DEVICES];
    static {
        NUM_SWITCHES[DEVC_BFR] = BfrComCam.NUM_RELAYS;
        NUM_SWITCHES[DEVC_PDU_5V] = Pdu5V.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_24VC] = ComCamPdu24VC.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_24VD] = ComCamPdu24VD.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_48V] = ComCamPdu48V.NUM_CHANS;
	//        NUM_SWITCHES[DEVC_REB_BULK] = RebBulkPS.NUM_BULKS;
    }
    
    public static final Map<String, Integer> switchNameToId = new HashMap<>();
    static {
	switchNameToId.put("ion pumps", SW_ION_PUMP);
	switchNameToId.put("v24cj6", SW_J6);
        switchNameToId.put("v24cj7", SW_J7);
        switchNameToId.put("v24cj8", SW_J8);
        switchNameToId.put("v24cj9", SW_J9);
        switchNameToId.put("v24cj13", SW_J13);
        switchNameToId.put("v24cj14", SW_J14);
	switchNameToId.put("scr1200" , SW_RELAY_PTH_CMC_SCR_00);
	switchNameToId.put("scr1200b" , SW_RELAY_PTH_CMC_SCR_00b);
        switchNameToId.put("vatvalve", SW_RELAY_AUX_CMC_DPP_01);
        switchNameToId.put("scr400"  , SW_RELAY_PTH_CMC_SCR_01);
        switchNameToId.put("shutter" , SW_RELAY_SHT_SHT_PSW_00);
        switchNameToId.put("cryoturbo", SW_RELAY_VCR_CMC_PCT_00);
        switchNameToId.put("scrollpump", SW_RELAY_DPP_01);
        switchNameToId.put("Clean5V", SW_RELAY_PWS_21);
        switchNameToId.put("Clean24V", SW_RELAY_PWS_20);
        switchNameToId.put("RebPs0", SW_RELAY_PWS_16);
        switchNameToId.put("Dirty24V", SW_RELAY_PWS_3);
        switchNameToId.put("Dirty28V", SW_RELAY_PWS_4);
        switchNameToId.put("Dirty48V", SW_RELAY_PWS_2);
	//        switchNameToId.put("Heater1", SW_RELAY_HTR_1);
	//        switchNameToId.put("Heater2", SW_RELAY_HTR_2);
        switchNameToId.put("Otm-A", SW_OTM_3_A);
        switchNameToId.put("Otm-B", SW_OTM_3_B);
        switchNameToId.put("Main24C", SW_MAIN_24C);
        switchNameToId.put("FESEncoder", SW_FES_ENCODER);
        switchNameToId.put("FESShutterHCUs", SW_HCU_FES_SHU);
        switchNameToId.put("IonPumps", SW_ION_PUMP);
        switchNameToId.put("BodyPurge", SW_BODY_PURGE);
        switchNameToId.put("BpuMaq20", SW_BPU_MAQ20);
        switchNameToId.put("Gauges", SW_GAUGES);
	//        switchNameToId.put("Shutter1C", SW_SHUTTER_1);
	//        switchNameToId.put("Shutter2C", SW_SHUTTER_2);
        switchNameToId.put("Main24D", SW_MAIN_24D);
	//        switchNameToId.put("CryoTurbo", SW_CRYO_TURBO);
        switchNameToId.put("PFTurbo", SW_PFTURBO);
        switchNameToId.put("FilterChanger", SW_FES);
	//        switchNameToId.put("ShutterBrake", SW_SHUTTER_BRAKE);
        switchNameToId.put("BoosterPump", SW_BOOSTER_PUMP);

        switchNameToId.put("Main48", SW_MAIN_48);
        switchNameToId.put("CryoTelCtrl0", SW_CRYOTEL_CTRL0);
        switchNameToId.put("CryoTelCtrl1", SW_CRYOTEL_CTRL1);
        switchNameToId.put("CryoTelCtrl2", SW_CRYOTEL_CTRL2);
        switchNameToId.put("PurgeFan", SW_PURGE_FAN);
        switchNameToId.put("RebBulk0", SW_REB_BULK_0);
    }

    public static final Map<Integer, String> switchIdToName = new HashMap<>();
    static {
        for (String name : switchNameToId.keySet()) {
            switchIdToName.put(switchNameToId.get(name), name);
        }
    }

}
