package org.lsst.ccs.subsystem.power.constants;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.BfrPathFinder;
import org.lsst.ccs.drivers.auxelex.ComCamPdu24VC;
import org.lsst.ccs.drivers.auxelex.ComCamPdu24VD;
import org.lsst.ccs.drivers.auxelex.ComCamPdu48V;
import org.lsst.ccs.drivers.auxelex.Pdu5V;
import org.lsst.ccs.drivers.auxelex.RebBulkPS;

/**
 * Quad box switch definitions.
 *
 * @author The CCS team
 */
public class PathFinderQuadBoxSwitches {


    public static final int
        DEVC_BFR      = 0,
        DEVC_PDU_5V   = 1,
        DEVC_PDU_24VC = 2,
        DEVC_PDU_24VD = 3,
        DEVC_PDU_48V  = 4,
        DEVC_REB_BULK = 5,
        NUM_DEVICES   = 6;

    public static final int
        SW_RELAY_HTR_1  = BfrPathFinder.RELAY_HTR_1 + 256 * DEVC_BFR,
        SW_RELAY_HTR_1b  = BfrPathFinder.RELAY_HTR_1b + 256 * DEVC_BFR,
        SW_RELAY_HTR_2  = BfrPathFinder.RELAY_HTR_2 + 256 * DEVC_BFR,
        SW_RELAY_PWS_2  = BfrPathFinder.RELAY_PWS_2 + 256 * DEVC_BFR,
        SW_RELAY_PWS_3  = BfrPathFinder.RELAY_PWS_3 + 256 * DEVC_BFR,
        SW_RELAY_PWS_4  = BfrPathFinder.RELAY_PWS_4 + 256 * DEVC_BFR,
        SW_RELAY_PWS_16 = BfrPathFinder.RELAY_PWS_16 + 256 * DEVC_BFR,
        SW_RELAY_PWS_17 = BfrPathFinder.RELAY_PWS_17 + 256 * DEVC_BFR,
        SW_RELAY_PWS_18 = BfrPathFinder.RELAY_PWS_18 + 256 * DEVC_BFR,
        SW_RELAY_PWS_19 = BfrPathFinder.RELAY_PWS_19 + 256 * DEVC_BFR,
        SW_RELAY_PWS_25 = BfrPathFinder.RELAY_PWS_25 + 256 * DEVC_BFR,
        SW_RELAY_PWS_20 = BfrPathFinder.RELAY_PWS_20 + 256 * DEVC_BFR,
        SW_RELAY_PWS_21 = BfrPathFinder.RELAY_PWS_21 + 256 * DEVC_BFR,
        SW_PDU_5V        = SW_RELAY_PWS_21,
        SW_PDU_24VC      = SW_RELAY_PWS_20,
        SW_PDU_24VD      = SW_RELAY_PWS_3,
        SW_PDU_48V       = SW_RELAY_PWS_2,
        SW_REB_BULK_PS_0 = SW_RELAY_PWS_16,
        SW_REB_BULK_PS_1 = SW_RELAY_PWS_17,
        SW_REB_BULK_PS_2 = SW_RELAY_PWS_18,
        SW_REB_BULK_PS_3 = SW_RELAY_PWS_19,
        SW_REB_BULK_PS_4 = SW_RELAY_PWS_25,
        SW_TRIM_HEATERS  = SW_RELAY_PWS_4,
        SW_HEATER_1      = SW_RELAY_HTR_1,
        SW_HEATER_2      = SW_RELAY_HTR_2;

    public static final int
        SW_OTM_0_A = Pdu5V.CHAN_OTM_0_A + 256 * DEVC_PDU_5V,
        SW_OTM_0_B = Pdu5V.CHAN_OTM_0_B + 256 * DEVC_PDU_5V;

    public static final int
        SW_MAIN_24C      = 0xff + 256 * DEVC_PDU_24VC,
	SW_ION_PUMP      = ComCamPdu24VC.CHAN_J5 + 256 * DEVC_PDU_24VC,
        SW_BPU_MAQ20     = ComCamPdu24VC.CHAN_BPU_MAQ20 + 256 * DEVC_PDU_24VC,
        SW_GAUGES        = ComCamPdu24VC.CHAN_J11 + 256 * DEVC_PDU_24VC,
        SW_BODY_PURGE    = ComCamPdu24VC.CHAN_J12 + 256 * DEVC_PDU_24VC,
        SW_FES_ENCODER   = ComCamPdu24VC.CHAN_J15 + 256 * DEVC_PDU_24VC,
        SW_HCU_FES_SHU   = ComCamPdu24VC.CHAN_J16 + 256 * DEVC_PDU_24VC;



    /*
    CHAN_ION_PUMP      = 0,
        CHAN_FES_LOADER_D  = 1,
        CHAN_PFTURBO       = 2,
        CHAN_FES           = 3,
        CHAN_PFSCROLL      = 4,
        CHAN_CRYO_TURBO    = 5,
        CHAN_SHUTTER_BRAKE = 6,
*/
    public static final int
        SW_MAIN_24D      = 0xff + 256 * DEVC_PDU_24VD,
        SW_FES_CHANGER_D = ComCamPdu24VD.CHAN_FES_LOADER_D + 256 * DEVC_PDU_24VD,
        SW_PFSCROLL      = ComCamPdu24VD.CHAN_PFSCROLL + 256 * DEVC_PDU_24VD,
        SW_PFTURBO       = ComCamPdu24VD.CHAN_PFTURBO + 256 * DEVC_PDU_24VD,
        SW_TURBO_HEATER  = ComCamPdu24VD.CHAN_TURBO_HEATER + 256 * DEVC_PDU_24VD;

    public static final int
        SW_MAIN_48        = 0xff + 256 * DEVC_PDU_48V,
        SW_PURGE_FAN      = ComCamPdu48V.CHAN_PURGE_FAN + 256 * DEVC_PDU_48V;

    public static final int
        SW_REB_BULK_0 = 0 + 256 * DEVC_REB_BULK;

    public static final int[] NUM_SWITCHES = new int[NUM_DEVICES];
    static {
        NUM_SWITCHES[DEVC_BFR] = BfrPathFinder.NUM_RELAYS;
        NUM_SWITCHES[DEVC_PDU_5V] = Pdu5V.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_24VC] = ComCamPdu24VC.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_24VD] = ComCamPdu24VD.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_48V] = ComCamPdu48V.NUM_CHANS;
        NUM_SWITCHES[DEVC_REB_BULK] = RebBulkPS.NUM_BULKS;
    }
    
    public static final Map<String, Integer> switchNameToId = new HashMap<>();
    static {
        switchNameToId.put("Clean5V", SW_RELAY_PWS_21);
        switchNameToId.put("Clean24V", SW_RELAY_PWS_20);
        switchNameToId.put("RebPs0", SW_RELAY_PWS_16);
        switchNameToId.put("Dirty24V", SW_RELAY_PWS_3);
        switchNameToId.put("Dirty28V", SW_RELAY_PWS_4);
        switchNameToId.put("Dirty48V", SW_RELAY_PWS_2);
        switchNameToId.put("Heater1", SW_RELAY_HTR_1);
        switchNameToId.put("Heater1b", SW_RELAY_HTR_1b);
        switchNameToId.put("Heater2", SW_RELAY_HTR_2);
        switchNameToId.put("Otm0-A", SW_OTM_0_A);
        switchNameToId.put("Otm0-B", SW_OTM_0_B);

        switchNameToId.put("Main24C", SW_MAIN_24C);
        switchNameToId.put("FESEncoder", SW_FES_ENCODER);
        switchNameToId.put("FesShutterHCUs", SW_HCU_FES_SHU);
        switchNameToId.put("IonPumps", SW_ION_PUMP);
        switchNameToId.put("RFGUTCBPUMaq20", SW_BODY_PURGE);
        switchNameToId.put("ValvesPTHMaq20", SW_BPU_MAQ20);
        switchNameToId.put("Gauges", SW_GAUGES);

        switchNameToId.put("Main24D", SW_MAIN_24D);
        switchNameToId.put("PFTurbo", SW_PFTURBO);
        switchNameToId.put("PFScroll", SW_PFSCROLL);
        switchNameToId.put("FesChangerD", SW_FES_CHANGER_D);
	switchNameToId.put("TurboHeater", SW_TURBO_HEATER);

        switchNameToId.put("Main48", SW_MAIN_48);
        switchNameToId.put("PurgeFan", SW_PURGE_FAN);
        switchNameToId.put("RebBulk0", SW_REB_BULK_0);
    }


    public static final Map<Integer, String> switchIdToName = new HashMap<>();
    static {
        for (String name : switchNameToId.keySet()) {
            switchIdToName.put(switchNameToId.get(name), name);
        }
    }

}
