package org.lsst.ccs.subsystem.power.alerts;

/**
 * Reb Power Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum RebPowerAlertType {

    /**
     * Alert raised when the HVBias Current is High.
     */
    HVBIAS_CURRENT_TOO_HIGH("Hv_Bias_Current_Is_High","Alarm for High HVBias current"),
    /**
     * Alert raised when the HVBias Voltage is high.
     */
    HVBIAS_VOLTAGE_TOO_HIGH("Hv_Bias_Voltage_Is_High","Alarm for High HVBias voltage"),
    /**
     * Alert raised when emergency actions fail.
     */
    EMERGENCY_ACTION_FAILED("Emergency_Action_Failed","Alarm raised when emergency actions have failed."),
    /**
     * Alert raised when a RebPs Board temperature is too high.
     */
    REB_PS_BOARD_TEMPERATURE_TOO_HIGH("RebPs_Board_Temperature_Is_High","Alarm raised when a RebPs board temperature is too high.");

    
    private final String id, description;
    
    RebPowerAlertType(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getAlertId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
}
