package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;

/**
 *  Contains the state of an ATS power supply subsystem
 *
 *  @author Owen Saxton
 */
public class ATSPowerState implements Serializable {
    
    public static final String KEY = "ATSPowerState";

    private final int tickMillis;         // Data status update period (ms)
    private final Boolean[] powerState;
    private final double hvBias;
    private final double dphi;
 
    public ATSPowerState(int tickMillis, Boolean[] powerState, double dphi, double hvBias)
    {
        this.tickMillis = tickMillis;
        this.powerState = powerState;
        this.hvBias = hvBias;
        this.dphi = dphi;
    }
    
    public int getTickMillis()
    {
        return tickMillis;
    }

    public Boolean[] getPowerState()
    {
        return powerState;
    }

    public double getHvBias()
    {
        return hvBias;
    }

    public double getDphi()
    {
        return dphi;
    }

    private static final long serialVersionUID = 7985485355845955312L;
}
