package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.power.constants.ComCamQuadBoxSwitches;
import org.lsst.ccs.subsystem.power.constants.SwitchState;

/**
 *  Contains the state of the quad box subsystem
 *
 *  @author Owen Saxton
 */
public class ComCamQuadBoxState implements Serializable {
    
    public final static String KEY = "ComCamQuadBoxState";

    private int tickMillis;         // Data status update period (ms)
    private final SwitchState[][] switchState = new SwitchState[ComCamQuadBoxSwitches.NUM_DEVICES][]; 
 
    public ComCamQuadBoxState()
    {
        switchState[ComCamQuadBoxSwitches.DEVC_BFR]
            = new SwitchState[ComCamQuadBoxSwitches.NUM_SWITCHES[ComCamQuadBoxSwitches.DEVC_BFR] + 1];
        switchState[ComCamQuadBoxSwitches.DEVC_PDU_5V]
            = new SwitchState[ComCamQuadBoxSwitches.NUM_SWITCHES[ComCamQuadBoxSwitches.DEVC_PDU_5V] + 1];
        switchState[ComCamQuadBoxSwitches.DEVC_PDU_24VC]
            = new SwitchState[ComCamQuadBoxSwitches.NUM_SWITCHES[ComCamQuadBoxSwitches.DEVC_PDU_24VC] + 1];
        switchState[ComCamQuadBoxSwitches.DEVC_PDU_24VD]
            = new SwitchState[ComCamQuadBoxSwitches.NUM_SWITCHES[ComCamQuadBoxSwitches.DEVC_PDU_24VD] + 1];
        switchState[ComCamQuadBoxSwitches.DEVC_PDU_48V]
            = new SwitchState[ComCamQuadBoxSwitches.NUM_SWITCHES[ComCamQuadBoxSwitches.DEVC_PDU_48V] + 1];
	//        switchState[ComCamQuadBoxSwitches.DEVC_REB_BULK]
	//            = new SwitchState[ComCamQuadBoxSwitches.NUM_SWITCHES[ComCamQuadBoxSwitches.DEVC_REB_BULK] + 1];
    }
    
    public void setTickMillis(int tickMillis)
    {
        this.tickMillis = tickMillis;
    }
    
    public int getTickMillis()
    {
        return tickMillis;
    }

    public void setSwitchState(int devNum, int swNum, SwitchState st)
    {
        switchState[devNum][swNum + 1] = st;
    }
    
    public SwitchState getSwitchState(int devNum, int swNum)
    {
        return switchState[devNum][swNum + 1];
    }

    public void setSwitchState(int swId, SwitchState st)
    {
        switchState[swId >> 8][(byte)swId + 1] = st;
    }
    
    public SwitchState getSwitchState(int swId)
    {
        return switchState[swId >> 8][(byte)swId + 1];
    }

    private static final long serialVersionUID = 7396502803894290440L;
}
