package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 *  Contains the state of a REB power supply subsystem
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class RebPsState implements Serializable {
    
    public static final String KEY = "RebPsState";

    private final int tickMillis;         // Data status update period (ms)
    private final int mainPowerState;
    private final int[] powerState;
    private final double[] hvBiasDacs;
    private final double[] dphiDacs;
    private final int psType;
    private final int psVersion;
    private final String psId;
 
    public RebPsState(int tickMillis, int mainPowerState, int[] powerState,
                      double[] hvBiasDacs, double[] dphiDacs, int psType, int psVersion, String psId)
    {
        this.tickMillis = tickMillis;
        this.mainPowerState = mainPowerState;
        this.powerState = powerState;
        this.hvBiasDacs = hvBiasDacs;
        this.dphiDacs = dphiDacs;
        this.psType = psType;
        this.psVersion = psVersion;
        this.psId = psId;
    }
    
    public int getTickMillis()
    {
        return tickMillis;
    }

    public int getMainPowerState()
    {
        return mainPowerState;
    }

    public int[] getPowerState()
    {
        return powerState;
    }

    public double[] getHvBiasDacs()
    {
        return hvBiasDacs;
    }

    public double[] getDphiDacs()
    {
        return dphiDacs;
    }

    public int getPsType()
    {
        return psType;
    }

    public int getPsVersion()
    {
        return psVersion;
    }

    public String getPsId()
    {
        return psId;
    }

    private static final long serialVersionUID = 1705687591673385919L;
}
