package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Contains the state of a power channel.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class PowerChanState implements Serializable {

    public final static String KEY = "PowerChanState";

    public static final int
        PWR_STATE_OFFLINE = -1,
        PWR_STATE_OFF     = 0,
        PWR_STATE_ON      = 1;

    private String name;
    private int state;
    private double voltage;
    private double current;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public double getVoltage() {
        return voltage;
    }

    public void setVoltage(double voltage) {
        this.voltage = voltage;
    }

    public double getCurrent() {
        return current;
    }

    public void setCurrent(double current) {
        this.current = current;
    }

    private static final long serialVersionUID = -6828549512413478467L;
}
