package org.lsst.ccs.subsystem.power.constants;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.Bfr;
import org.lsst.ccs.drivers.auxelex.Pdu24VC;
import org.lsst.ccs.drivers.auxelex.Pdu24VD;
import org.lsst.ccs.drivers.auxelex.Pdu48V;
import org.lsst.ccs.drivers.auxelex.Pdu5V;
import org.lsst.ccs.drivers.auxelex.RebBulkPS;

/**
 * Quad box switch definitions.
 *
 * @author The CCS tesm
 */
public class QuadBoxSwitches {

    public static final int
        DEVC_BFR      = 0,
        DEVC_PDU_5V   = 1,
        DEVC_PDU_24VC = 2,
        DEVC_PDU_24VD = 3,
        DEVC_PDU_48V  = 4,
        DEVC_REB_BULK = 5,
        NUM_DEVICES   = 6;

    public static final int
        SW_RELAY_HTR_1  = Bfr.RELAY_HTR_1 + 256 * DEVC_BFR,
        SW_RELAY_HTR_2  = Bfr.RELAY_HTR_2 + 256 * DEVC_BFR,
        SW_RELAY_PWS_2  = Bfr.RELAY_PWS_2 + 256 * DEVC_BFR,
        SW_RELAY_PWS_3  = Bfr.RELAY_PWS_3 + 256 * DEVC_BFR,
        SW_RELAY_PWS_4  = Bfr.RELAY_PWS_4 + 256 * DEVC_BFR,
        SW_RELAY_PWS_16 = Bfr.RELAY_PWS_16 + 256 * DEVC_BFR,
        SW_RELAY_PWS_17 = Bfr.RELAY_PWS_17 + 256 * DEVC_BFR,
        SW_RELAY_PWS_18 = Bfr.RELAY_PWS_18 + 256 * DEVC_BFR,
        SW_RELAY_PWS_19 = Bfr.RELAY_PWS_19 + 256 * DEVC_BFR,
        SW_RELAY_PWS_25 = Bfr.RELAY_PWS_25 + 256 * DEVC_BFR,
        SW_RELAY_PWS_20 = Bfr.RELAY_PWS_20 + 256 * DEVC_BFR,
        SW_RELAY_PWS_21 = Bfr.RELAY_PWS_21 + 256 * DEVC_BFR,
        SW_PDU_5V        = SW_RELAY_PWS_21,
        SW_PDU_24VC      = SW_RELAY_PWS_20,
        SW_PDU_24VD      = SW_RELAY_PWS_3,
        SW_PDU_48V       = SW_RELAY_PWS_2,
        SW_REB_BULK_PS_0 = SW_RELAY_PWS_16,
        SW_REB_BULK_PS_1 = SW_RELAY_PWS_17,
        SW_REB_BULK_PS_2 = SW_RELAY_PWS_18,
        SW_REB_BULK_PS_3 = SW_RELAY_PWS_19,
        SW_REB_BULK_PS_4 = SW_RELAY_PWS_25,
        SW_TRIM_HEATERS  = SW_RELAY_PWS_4,
        SW_HEATER_1      = SW_RELAY_HTR_1,
        SW_HEATER_2      = SW_RELAY_HTR_2;

    public static final int
        SW_OTM_0_A = Pdu5V.CHAN_OTM_0_A + 256 * DEVC_PDU_5V,
        SW_OTM_0_B = Pdu5V.CHAN_OTM_0_B + 256 * DEVC_PDU_5V,
        SW_OTM_1_A = Pdu5V.CHAN_OTM_1_A + 256 * DEVC_PDU_5V,
        SW_OTM_1_B = Pdu5V.CHAN_OTM_1_B + 256 * DEVC_PDU_5V,
        SW_OTM_2_A = Pdu5V.CHAN_OTM_2_A + 256 * DEVC_PDU_5V,
        SW_OTM_2_B = Pdu5V.CHAN_OTM_2_B + 256 * DEVC_PDU_5V,
        SW_OTM_3_A = Pdu5V.CHAN_OTM_3_A + 256 * DEVC_PDU_5V,
        SW_OTM_3_B = Pdu5V.CHAN_OTM_3_B + 256 * DEVC_PDU_5V,
        SW_OTM_4_A = Pdu5V.CHAN_OTM_4_A + 256 * DEVC_PDU_5V,
        SW_OTM_4_B = Pdu5V.CHAN_OTM_4_B + 256 * DEVC_PDU_5V,
        SW_OTM_5_A = Pdu5V.CHAN_OTM_5_A + 256 * DEVC_PDU_5V,
        SW_OTM_5_B = Pdu5V.CHAN_OTM_5_B + 256 * DEVC_PDU_5V;

    public static final int
        SW_MAIN_24C      = 0xff + 256 * DEVC_PDU_24VC,
        SW_ION_PUMPS     = Pdu24VC.CHAN_ION_PUMPS + 256 * DEVC_PDU_24VC,
        SW_UNUSED_24C    = Pdu24VC.CHAN_UNUSED_24C + 256 * DEVC_PDU_24VC,
        SW_FES_CHANGER_C = Pdu24VC.CHAN_FES_CHANGER_C + 256 * DEVC_PDU_24VC,
        SW_UT_MAQ20S     = Pdu24VC.CHAN_UT_MAQ20S + 256 * DEVC_PDU_24VC,
        SW_SHUTTER_1     = Pdu24VC.CHAN_SHUTTER_1 + 256 * DEVC_PDU_24VC,
        SW_SHUTTER_2     = Pdu24VC.CHAN_SHUTTER_2 + 256 * DEVC_PDU_24VC,
        SW_FES_CAROUSEL  = Pdu24VC.CHAN_FES_CAROUSEL + 256 * DEVC_PDU_24VC,
        SW_FES_LOADER_C  = Pdu24VC.CHAN_FES_LOADER_C + 256 * DEVC_PDU_24VC,
        SW_BODY_MAQ20    = Pdu24VC.CHAN_BODY_MAQ20 + 256 * DEVC_PDU_24VC,
        SW_GAUGES        = Pdu24VC.CHAN_GAUGES + 256 * DEVC_PDU_24VC;

    public static final int
        SW_MAIN_24D      = 0xff + 256 * DEVC_PDU_24VD,
        SW_FES_LOADER_D  = Pdu24VD.CHAN_FES_LOADER_D + 256 * DEVC_PDU_24VD,
        SW_FES_CHANGER_D = Pdu24VD.CHAN_FES_CHANGER_D + 256 * DEVC_PDU_24VD,
        SW_CRYO_TURBO    = Pdu24VD.CHAN_CRYO_TURBO + 256 * DEVC_PDU_24VD,
        SW_HEX_TURBO     = Pdu24VD.CHAN_HEX_TURBO + 256 * DEVC_PDU_24VD,
        SW_FES_CLAMPS    = Pdu24VD.CHAN_FES_CLAMPS + 256 * DEVC_PDU_24VD,
        SW_FES_BRAKES    = Pdu24VD.CHAN_FES_BRAKES + 256 * DEVC_PDU_24VD,
        SW_SHUTTER_BRAKE = Pdu24VD.CHAN_SHUTTER_BRAKE + 256 * DEVC_PDU_24VD;

    public static final int
        SW_MAIN_48        = 0xff + 256 * DEVC_PDU_48V,
        SW_FES_CAROUSEL_D = Pdu48V.CHAN_FES_CAROUSEL_D + 256 * DEVC_PDU_48V,
        SW_SHUTTER_1_D    = Pdu48V.CHAN_SHUTTER_1_D + 256 * DEVC_PDU_48V,
        SW_SHUTTER_2_D    = Pdu48V.CHAN_SHUTTER_2_D + 256 * DEVC_PDU_48V,
        SW_PURGE_FAN      = Pdu48V.CHAN_PURGE_FAN + 256 * DEVC_PDU_48V,
        SW_FES_HEATER     = Pdu48V.CHAN_FES_HEATER  + 256 * DEVC_PDU_48V;

    public static final int
        SW_REB_BULK_0 = 0 + 256 * DEVC_REB_BULK,
        SW_REB_BULK_1 = 1 + 256 * DEVC_REB_BULK,
        SW_REB_BULK_2 = 2 + 256 * DEVC_REB_BULK,
        SW_REB_BULK_3 = 3 + 256 * DEVC_REB_BULK,
        SW_REB_BULK_4 = 4 + 256 * DEVC_REB_BULK;

    public static final int[] NUM_SWITCHES = new int[NUM_DEVICES];
    static {
        NUM_SWITCHES[DEVC_BFR] = Bfr.NUM_RELAYS;
        NUM_SWITCHES[DEVC_PDU_5V] = Pdu5V.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_24VC] = Pdu24VC.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_24VD] = Pdu24VD.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_48V] = Pdu48V.NUM_CHANS;
        NUM_SWITCHES[DEVC_REB_BULK] = RebBulkPS.NUM_BULKS;
    }
    
    public static final Map<String, Integer> switchNameToId = new HashMap<>();
    static {
        switchNameToId.put("Clean5V", SW_RELAY_PWS_21);
        switchNameToId.put("Clean24V", SW_RELAY_PWS_20);
        switchNameToId.put("RebPs0-2", SW_RELAY_PWS_16);
        switchNameToId.put("RebPs3-5", SW_RELAY_PWS_17);
        switchNameToId.put("RebPs6-8", SW_RELAY_PWS_18);
        switchNameToId.put("RebPs9-12", SW_RELAY_PWS_19);
        switchNameToId.put("RebPsSpare", SW_RELAY_PWS_25);
        switchNameToId.put("Dirty24V", SW_RELAY_PWS_3);
        switchNameToId.put("Dirty28V", SW_RELAY_PWS_4);
        switchNameToId.put("Dirty48V", SW_RELAY_PWS_2);
        switchNameToId.put("Heater1", SW_RELAY_HTR_1);
        switchNameToId.put("Heater2", SW_RELAY_HTR_2);
        switchNameToId.put("Otm0-A", SW_OTM_0_A);
        switchNameToId.put("Otm0-B", SW_OTM_0_B);
        switchNameToId.put("Otm1-A", SW_OTM_1_A);
        switchNameToId.put("Otm1-B", SW_OTM_1_B);
        switchNameToId.put("Otm2-A", SW_OTM_2_A);
        switchNameToId.put("Otm2-B", SW_OTM_2_B);
        switchNameToId.put("Otm3-A", SW_OTM_3_A);
        switchNameToId.put("Otm3-B", SW_OTM_3_B);
        switchNameToId.put("Otm4-A", SW_OTM_4_A);
        switchNameToId.put("Otm4-B", SW_OTM_4_B);
        switchNameToId.put("Otm5-A", SW_OTM_5_A);
        switchNameToId.put("Otm5-B", SW_OTM_5_B);
        switchNameToId.put("Main24C", SW_MAIN_24C);
        switchNameToId.put("IonPumps", SW_ION_PUMPS);
        switchNameToId.put("BodyMaq20", SW_BODY_MAQ20);
        switchNameToId.put("UtMaq20s", SW_UT_MAQ20S);
        switchNameToId.put("Gauges", SW_GAUGES);
        switchNameToId.put("FesCarousel", SW_FES_CAROUSEL);
        switchNameToId.put("FesChangerC", SW_FES_CHANGER_C);
        switchNameToId.put("FesLoaderC", SW_FES_LOADER_C);
        switchNameToId.put("Shutter1C", SW_SHUTTER_1);
        switchNameToId.put("Shutter2C", SW_SHUTTER_2);
        switchNameToId.put("Main24D", SW_MAIN_24D);
        switchNameToId.put("CryoTurbo", SW_CRYO_TURBO);
        switchNameToId.put("HexTurbo", SW_HEX_TURBO);
        switchNameToId.put("FesClamps", SW_FES_CLAMPS);
        switchNameToId.put("FesBrake", SW_FES_BRAKES);
        switchNameToId.put("FesChangerD", SW_FES_CHANGER_D);
        switchNameToId.put("FesLoaderD", SW_FES_LOADER_D);
        switchNameToId.put("ShutterBrake", SW_SHUTTER_BRAKE);
        switchNameToId.put("Main48", SW_MAIN_48);
        switchNameToId.put("PurgeFan", SW_PURGE_FAN);
        switchNameToId.put("FesCarouselD", SW_FES_CAROUSEL_D);
        switchNameToId.put("FesHeater", SW_FES_HEATER); 
        switchNameToId.put("Shutter1D", SW_SHUTTER_1_D);
        switchNameToId.put("Shutter2D", SW_SHUTTER_2_D);
        switchNameToId.put("RebBulk0-2", SW_REB_BULK_0);
        switchNameToId.put("RebBulk3-5", SW_REB_BULK_1);
        switchNameToId.put("RebBulk6-8", SW_REB_BULK_2);
        switchNameToId.put("RebBulk9-12", SW_REB_BULK_3);
        switchNameToId.put("RebBulkSpare", SW_REB_BULK_4);
    }

    public static final Map<Integer, String> switchIdToName = new HashMap<>();
    static {
        for (String name : switchNameToId.keySet()) {
            switchIdToName.put(switchNameToId.get(name), name);
        }
    }

}
