package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;

/**
 *  Contains the state of a general power supply subsystem
 *
 *  @author Owen Saxton
 */
public class PowerState implements Serializable {
    
    public final static String KEY = "PowerState";

    private final int tickMillis;         // Data status update period (ms)
 
    public PowerState(int tickMillis)
    {
        this.tickMillis = tickMillis;
    }
    
    public int getTickMillis()
    {
        return tickMillis;
    }

    @Override
    public String toString()
    {
        return "tickMillis=" + tickMillis;
    }

    private static final long serialVersionUID = -6242812951668379226L;
}
