package org.lsst.ccs.subsystem.power.constants;

import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.Bfr;
import org.lsst.ccs.drivers.auxelex.Pdu24VC;
import org.lsst.ccs.drivers.auxelex.Pdu24VD;
import org.lsst.ccs.drivers.auxelex.Pdu48V;
import org.lsst.ccs.drivers.auxelex.Pdu5V;
import org.lsst.ccs.drivers.auxelex.RebBulkPS;

/**
 * Quad box switch definitions.
 *
 * @author The CCS tesm
 */
public class QuadBoxSwitches {

    public static final int
        DEVC_BFR      = 0,
        DEVC_PDU_5V   = 1,
        DEVC_PDU_24VC = 2,
        DEVC_PDU_24VD = 3,
        DEVC_PDU_48V  = 4,
        DEVC_REB_BULK = 5,
        NUM_DEVICES   = 6;

    public static final int
        SW_RELAY_HTR_1  = Bfr.RELAY_HTR_1 + 256 * DEVC_BFR,
        SW_RELAY_HTR_2  = Bfr.RELAY_HTR_2 + 256 * DEVC_BFR,
        SW_RELAY_PWS_2  = Bfr.RELAY_PWS_2 + 256 * DEVC_BFR,
        SW_RELAY_PWS_3  = Bfr.RELAY_PWS_3 + 256 * DEVC_BFR,
        SW_RELAY_PWS_4  = Bfr.RELAY_PWS_4 + 256 * DEVC_BFR,
        SW_RELAY_PWS_16 = Bfr.RELAY_PWS_16 + 256 * DEVC_BFR,
        SW_RELAY_PWS_17 = Bfr.RELAY_PWS_17 + 256 * DEVC_BFR,
        SW_RELAY_PWS_18 = Bfr.RELAY_PWS_18 + 256 * DEVC_BFR,
        SW_RELAY_PWS_19 = Bfr.RELAY_PWS_19 + 256 * DEVC_BFR,
        SW_RELAY_PWS_25 = Bfr.RELAY_PWS_25 + 256 * DEVC_BFR,
        SW_RELAY_PWS_20 = Bfr.RELAY_PWS_20 + 256 * DEVC_BFR,
        SW_RELAY_PWS_21 = Bfr.RELAY_PWS_21 + 256 * DEVC_BFR;

    public static final int
        SW_OTM_0_A = Pdu5V.CHAN_OTM_0_A + 256 * DEVC_PDU_5V,
        SW_OTM_0_B = Pdu5V.CHAN_OTM_0_B + 256 * DEVC_PDU_5V,
        SW_OTM_1_A = Pdu5V.CHAN_OTM_1_A + 256 * DEVC_PDU_5V,
        SW_OTM_1_B = Pdu5V.CHAN_OTM_1_B + 256 * DEVC_PDU_5V,
        SW_OTM_2_A = Pdu5V.CHAN_OTM_2_A + 256 * DEVC_PDU_5V,
        SW_OTM_2_B = Pdu5V.CHAN_OTM_2_B + 256 * DEVC_PDU_5V,
        SW_OTM_3_A = Pdu5V.CHAN_OTM_3_A + 256 * DEVC_PDU_5V,
        SW_OTM_3_B = Pdu5V.CHAN_OTM_3_B + 256 * DEVC_PDU_5V,
        SW_OTM_4_A = Pdu5V.CHAN_OTM_4_A + 256 * DEVC_PDU_5V,
        SW_OTM_4_B = Pdu5V.CHAN_OTM_4_B + 256 * DEVC_PDU_5V,
        SW_OTM_5_A = Pdu5V.CHAN_OTM_5_A + 256 * DEVC_PDU_5V,
        SW_OTM_5_B = Pdu5V.CHAN_OTM_5_B + 256 * DEVC_PDU_5V;

    public static final int
        SW_MAIN_24C      = 0xff + 256 * DEVC_PDU_24VC,
        SW_ION_PUMPS     = Pdu24VC.CHAN_ION_PUMPS + 256 * DEVC_PDU_24VC,
        SW_UNUSED_24C    = Pdu24VC.CHAN_UNUSED_24C + 256 * DEVC_PDU_24VC,
        SW_FES_CHANGER_C = Pdu24VC.CHAN_FES_CHANGER_C + 256 * DEVC_PDU_24VC,
        SW_BPU_MAQ20     = Pdu24VC.CHAN_BPU_MAQ20 + 256 * DEVC_PDU_24VC,
        SW_SHUTTER_1     = Pdu24VC.CHAN_SHUTTER_1 + 256 * DEVC_PDU_24VC,
        SW_SHUTTER_2     = Pdu24VC.CHAN_SHUTTER_2 + 256 * DEVC_PDU_24VC,
        SW_FES_CAROUSEL  = Pdu24VC.CHAN_FES_CAROUSEL + 256 * DEVC_PDU_24VC,
        SW_FES_LOADER_C  = Pdu24VC.CHAN_FES_LOADER_C + 256 * DEVC_PDU_24VC,
        SW_BODY_PURGE    = Pdu24VC.CHAN_BODY_PURGE + 256 * DEVC_PDU_24VC,
        SW_GAUGES        = Pdu24VC.CHAN_GAUGES + 256 * DEVC_PDU_24VC,
        SW_HCU_PWR_CRY   = Pdu24VC.CHAN_HCU_PWR_CRY + 256 * DEVC_PDU_24VC,
        SW_HCU_FES_SHU   = Pdu24VC.CHAN_HCU_FES_SHU + 256 * DEVC_PDU_24VC;

    public static final int
        SW_MAIN_24D      = 0xff + 256 * DEVC_PDU_24VD,
        SW_FES_LOADER_D  = Pdu24VD.CHAN_FES_LOADER_D + 256 * DEVC_PDU_24VD,
        SW_FES_CHANGER_D = Pdu24VD.CHAN_FES_CHANGER_D + 256 * DEVC_PDU_24VD,
        SW_CRYO_TURBO    = Pdu24VD.CHAN_CRYO_TURBO + 256 * DEVC_PDU_24VD,
        SW_HEX_TURBO     = Pdu24VD.CHAN_HEX_TURBO + 256 * DEVC_PDU_24VD,
        SW_FES_CLAMPS    = Pdu24VD.CHAN_FES_CLAMPS + 256 * DEVC_PDU_24VD,
        SW_FES_BRAKES    = Pdu24VD.CHAN_FES_BRAKES + 256 * DEVC_PDU_24VD,
        SW_SHUTTER_BRAKE = Pdu24VD.CHAN_SHUTTER_BRAKE + 256 * DEVC_PDU_24VD;

    public static final int
        SW_MAIN_48        = 0xff + 256 * DEVC_PDU_48V,
        SW_FES_CAROUSEL_D = Pdu48V.CHAN_FES_CAROUSEL_D + 256 * DEVC_PDU_48V,
        SW_SHUTTER_1_D    = Pdu48V.CHAN_SHUTTER_1_D + 256 * DEVC_PDU_48V,
        SW_SHUTTER_2_D    = Pdu48V.CHAN_SHUTTER_2_D + 256 * DEVC_PDU_48V,
        SW_PURGE_FAN      = Pdu48V.CHAN_PURGE_FAN + 256 * DEVC_PDU_48V,
        SW_FES_HEATER     = Pdu48V.CHAN_FES_HEATER  + 256 * DEVC_PDU_48V;

    public static final int
        SW_REB_BULK_0 = 0 + 256 * DEVC_REB_BULK,
        SW_REB_BULK_1 = 1 + 256 * DEVC_REB_BULK,
        SW_REB_BULK_2 = 2 + 256 * DEVC_REB_BULK,
        SW_REB_BULK_3 = 3 + 256 * DEVC_REB_BULK,
        SW_REB_BULK_4 = 4 + 256 * DEVC_REB_BULK;

    public static final int[] NUM_SWITCHES = new int[NUM_DEVICES];
    static {
        NUM_SWITCHES[DEVC_BFR] = Bfr.NUM_RELAYS;
        NUM_SWITCHES[DEVC_PDU_5V] = Pdu5V.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_24VC] = Pdu24VC.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_24VD] = Pdu24VD.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_48V] = Pdu48V.NUM_CHANS;
        NUM_SWITCHES[DEVC_REB_BULK] = RebBulkPS.NUM_BULKS;
    }
    
    public static final Map<String, Integer> switchNames = new LinkedHashMap<>();
    static {
        switchNames.put("Clean5V", SW_RELAY_PWS_21);
        switchNames.put("Clean24V", SW_RELAY_PWS_20);
        switchNames.put("RebPs0-2", SW_RELAY_PWS_16);
        switchNames.put("RebPs3-5", SW_RELAY_PWS_17);
        switchNames.put("RebPs6-8", SW_RELAY_PWS_18);
        switchNames.put("RebPs9-12", SW_RELAY_PWS_19);
        switchNames.put("RebPsSpare", SW_RELAY_PWS_25);
        switchNames.put("Dirty24V", SW_RELAY_PWS_3);
        switchNames.put("Dirty28V", SW_RELAY_PWS_4);
        switchNames.put("Dirty48V", SW_RELAY_PWS_2);
        switchNames.put("Heater1", SW_RELAY_HTR_1);
        switchNames.put("Heater2", SW_RELAY_HTR_2);
        switchNames.put("Otm0-A", SW_OTM_0_A);
        switchNames.put("Otm0-B", SW_OTM_0_B);
        switchNames.put("Otm1-A", SW_OTM_1_A);
        switchNames.put("Otm1-B", SW_OTM_1_B);
        switchNames.put("Otm2-A", SW_OTM_2_A);
        switchNames.put("Otm2-B", SW_OTM_2_B);
        switchNames.put("Otm3-A", SW_OTM_3_A);
        switchNames.put("Otm3-B", SW_OTM_3_B);
        switchNames.put("Otm4-A", SW_OTM_4_A);
        switchNames.put("Otm4-B", SW_OTM_4_B);
        switchNames.put("Otm5-A", SW_OTM_5_A);
        switchNames.put("Otm5-B", SW_OTM_5_B);
        switchNames.put("Main24C", SW_MAIN_24C);
        switchNames.put("PowerCryoHCUs", SW_HCU_PWR_CRY);
        switchNames.put("FesShutterHCUs", SW_HCU_FES_SHU);
        switchNames.put("IonPumps", SW_ION_PUMPS);
        switchNames.put("BodyPurge", SW_BODY_PURGE);
        switchNames.put("BpuMaq20", SW_BPU_MAQ20);
        switchNames.put("Gauges", SW_GAUGES);
        switchNames.put("FesCarousel", SW_FES_CAROUSEL);
        switchNames.put("FesChangerC", SW_FES_CHANGER_C);
        switchNames.put("FesLoaderC", SW_FES_LOADER_C);
        switchNames.put("Shutter1C", SW_SHUTTER_1);
        switchNames.put("Shutter2C", SW_SHUTTER_2);
        switchNames.put("Main24D", SW_MAIN_24D);
        switchNames.put("CryoTurbo", SW_CRYO_TURBO);
        switchNames.put("HexTurbo", SW_HEX_TURBO);
        switchNames.put("FesClamps", SW_FES_CLAMPS);
        switchNames.put("FesBrake", SW_FES_BRAKES);
        switchNames.put("FesChangerD", SW_FES_CHANGER_D);
        switchNames.put("FesLoaderD", SW_FES_LOADER_D);
        switchNames.put("ShutterBrake", SW_SHUTTER_BRAKE);
        switchNames.put("Main48", SW_MAIN_48);
        switchNames.put("PurgeFan", SW_PURGE_FAN);
        switchNames.put("FesCarouselD", SW_FES_CAROUSEL_D);
        switchNames.put("FesHheater", SW_FES_HEATER); 
        switchNames.put("Shutter1D", SW_SHUTTER_1_D);
        switchNames.put("Shutter2D", SW_SHUTTER_2_D);
        switchNames.put("RebBulk0-2", SW_REB_BULK_0);
        switchNames.put("RebBulk3-5", SW_REB_BULK_1);
        switchNames.put("RebBulk6-8", SW_REB_BULK_2);
        switchNames.put("RebBulk9-12", SW_REB_BULK_3);
        switchNames.put("RebBulkSpare", SW_REB_BULK_4);
    }

}
