package org.lsst.ccs.subsystem.power.constants;

import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.Bfr;
import org.lsst.ccs.drivers.auxelex.PduHV;
import org.lsst.ccs.drivers.auxelex.PduLV;

/**
 * Quad box switch definitions.
 *
 * @author The CCS tesm
 */
public class QuadBoxSwitches {

    public static final int
        DEVC_BFR      = 0,
        DEVC_PDU_5V   = 1,
        DEVC_PDU_24VC = 2,
        DEVC_PDU_24VD = 3,
        DEVC_PDU_48V  = 4,
        NUM_DEVICES   = 5;

    public static final int
        SW_RELAY_HTR_1  = Bfr.RELAY_HTR_1 + 256 * DEVC_BFR,
        SW_RELAY_HTR_2  = Bfr.RELAY_HTR_2 + 256 * DEVC_BFR,
        SW_RELAY_PWS_2  = Bfr.RELAY_PWS_2 + 256 * DEVC_BFR,
        SW_RELAY_PWS_3  = Bfr.RELAY_PWS_3 + 256 * DEVC_BFR,
        SW_RELAY_PWS_4  = Bfr.RELAY_PWS_4 + 256 * DEVC_BFR,
        SW_RELAY_PWS_16 = Bfr.RELAY_PWS_16 + 256 * DEVC_BFR,
        SW_RELAY_PWS_17 = Bfr.RELAY_PWS_17 + 256 * DEVC_BFR,
        SW_RELAY_PWS_18 = Bfr.RELAY_PWS_18 + 256 * DEVC_BFR,
        SW_RELAY_PWS_19 = Bfr.RELAY_PWS_19 + 256 * DEVC_BFR,
        SW_RELAY_PWS_25 = Bfr.RELAY_PWS_25 + 256 * DEVC_BFR,
        SW_RELAY_PWS_20 = Bfr.RELAY_PWS_20 + 256 * DEVC_BFR,
        SW_RELAY_PWS_21 = Bfr.RELAY_PWS_21 + 256 * DEVC_BFR;

    public static final int
        SW_OTM_0_A = PduLV.CHAN_OTM_0_A + 256 * DEVC_PDU_5V,
        SW_OTM_0_B = PduLV.CHAN_OTM_0_B + 256 * DEVC_PDU_5V,
        SW_OTM_1_A = PduLV.CHAN_OTM_1_A + 256 * DEVC_PDU_5V,
        SW_OTM_1_B = PduLV.CHAN_OTM_1_B + 256 * DEVC_PDU_5V,
        SW_OTM_2_A = PduLV.CHAN_OTM_2_A + 256 * DEVC_PDU_5V,
        SW_OTM_2_B = PduLV.CHAN_OTM_2_B + 256 * DEVC_PDU_5V,
        SW_OTM_3_A = PduLV.CHAN_OTM_3_A + 256 * DEVC_PDU_5V,
        SW_OTM_3_B = PduLV.CHAN_OTM_3_B + 256 * DEVC_PDU_5V,
        SW_OTM_4_A = PduLV.CHAN_OTM_4_A + 256 * DEVC_PDU_5V,
        SW_OTM_4_B = PduLV.CHAN_OTM_4_B + 256 * DEVC_PDU_5V,
        SW_OTM_5_A = PduLV.CHAN_OTM_5_A + 256 * DEVC_PDU_5V,
        SW_OTM_5_B = PduLV.CHAN_OTM_5_B + 256 * DEVC_PDU_5V;

    public static final int
        SW_MAIN_24C      = 0xff + 256 * DEVC_PDU_24VC,
        SW_ION_PUMPS     = PduHV.CHAN_ION_PUMPS + 256 * DEVC_PDU_24VC,
        SW_UNUSED_24C    = PduHV.CHAN_UNUSED_24C + 256 * DEVC_PDU_24VC,
        SW_FES_CHANGER_C = PduHV.CHAN_FES_CHANGER_C + 256 * DEVC_PDU_24VC,
        SW_BPU_MAQ20     = PduHV.CHAN_BPU_MAQ20 + 256 * DEVC_PDU_24VC,
        SW_SHUTTER_1     = PduHV.CHAN_SHUTTER_1 + 256 * DEVC_PDU_24VC,
        SW_SHUTTER_2     = PduHV.CHAN_SHUTTER_2 + 256 * DEVC_PDU_24VC,
        SW_FES_CAROUSEL  = PduHV.CHAN_FES_CAROUSEL + 256 * DEVC_PDU_24VC,
        SW_FES_LOADER_C  = PduHV.CHAN_FES_LOADER_C + 256 * DEVC_PDU_24VC,
        SW_BODY_PURGE    = PduHV.CHAN_BODY_PURGE + 256 * DEVC_PDU_24VC,
        SW_GAUGES        = PduHV.CHAN_GAUGES + 256 * DEVC_PDU_24VC,
        SW_HCU_PWR_CRY   = PduHV.CHAN_HCU_PWR_CRY + 256 * DEVC_PDU_24VC,
        SW_HCU_FES_SHU   = PduHV.CHAN_HCU_FES_SHU + 256 * DEVC_PDU_24VC;

    public static final int
        SW_MAIN_24D      = 0xff + 256 * DEVC_PDU_24VD,
        SW_FES_LOADER_D  = PduHV.CHAN_FES_LOADER_D + 256 * DEVC_PDU_24VD,
        SW_FES_CHANGER_D = PduHV.CHAN_FES_CHANGER_D + 256 * DEVC_PDU_24VD,
        SW_CRYO_TURBO    = PduHV.CHAN_CRYO_TURBO + 256 * DEVC_PDU_24VD,
        SW_HEX_TURBO     = PduHV.CHAN_HEX_TURBO + 256 * DEVC_PDU_24VD,
        SW_FES_CLAMPS    = PduHV.CHAN_FES_CLAMPS + 256 * DEVC_PDU_24VD,
        SW_FES_BRAKES    = PduHV.CHAN_FES_BRAKES + 256 * DEVC_PDU_24VD,
        SW_SHUTTER_BRAKE = PduHV.CHAN_SHUTTER_BRAKE + 256 * DEVC_PDU_24VD;

    public static final int
        SW_MAIN_48        = 0xff + 256 * DEVC_PDU_48V,
        SW_FES_CAROUSEL_D = PduHV.CHAN_FES_CAROUSEL_D + 256 * DEVC_PDU_48V,
        SW_SHUTTER_1_D    = PduHV.CHAN_SHUTTER_1_D + 256 * DEVC_PDU_48V,
        SW_SHUTTER_2_D    = PduHV.CHAN_SHUTTER_2_D + 256 * DEVC_PDU_48V,
        SW_PURGE_FAN      = PduHV.CHAN_PURGE_FAN + 256 * DEVC_PDU_48V,
        SW_FES_HEATER     = PduHV.CHAN_FES_HEATER  + 256 * DEVC_PDU_48V;

    public static final int[] NUM_SWITCHES = new int[NUM_DEVICES];
    static {
        NUM_SWITCHES[DEVC_BFR] = Bfr.NUM_RELAYS;
        NUM_SWITCHES[DEVC_PDU_5V] = PduLV.NUM_CHANS;
        NUM_SWITCHES[DEVC_PDU_24VC] = PduHV.NUM_CHANS_24C;
        NUM_SWITCHES[DEVC_PDU_24VD] = PduHV.NUM_CHANS_24D;
        NUM_SWITCHES[DEVC_PDU_48V] = PduHV.NUM_CHANS_48;
    }
    
    public static final Map<String, Integer> switchNames = new LinkedHashMap<>();
    static {
        switchNames.put("Clean5V", QuadBoxSwitches.SW_RELAY_PWS_21);
        switchNames.put("Clean24V", QuadBoxSwitches.SW_RELAY_PWS_20);
        switchNames.put("RebPs0-2", QuadBoxSwitches.SW_RELAY_PWS_16);
        switchNames.put("RebPs3-5", QuadBoxSwitches.SW_RELAY_PWS_17);
        switchNames.put("RebPs6-8", QuadBoxSwitches.SW_RELAY_PWS_18);
        switchNames.put("RebPs9-12", QuadBoxSwitches.SW_RELAY_PWS_19);
        switchNames.put("RebPsSpare", QuadBoxSwitches.SW_RELAY_PWS_25);
        switchNames.put("Dirty24V", QuadBoxSwitches.SW_RELAY_PWS_3);
        switchNames.put("Dirty28V", QuadBoxSwitches.SW_RELAY_PWS_4);
        switchNames.put("Dirty48V", QuadBoxSwitches.SW_RELAY_PWS_2);
        switchNames.put("Heater1", QuadBoxSwitches.SW_RELAY_HTR_1);
        switchNames.put("Heater2", QuadBoxSwitches.SW_RELAY_HTR_2);
        switchNames.put("Otm0-A", QuadBoxSwitches.SW_OTM_0_A);
        switchNames.put("Otm0-B", QuadBoxSwitches.SW_OTM_0_B);
        switchNames.put("Otm1-A", QuadBoxSwitches.SW_OTM_1_A);
        switchNames.put("Otm1-B", QuadBoxSwitches.SW_OTM_1_B);
        switchNames.put("Otm2-A", QuadBoxSwitches.SW_OTM_2_A);
        switchNames.put("Otm2-B", QuadBoxSwitches.SW_OTM_2_B);
        switchNames.put("Otm3-A", QuadBoxSwitches.SW_OTM_3_A);
        switchNames.put("Otm3-B", QuadBoxSwitches.SW_OTM_3_B);
        switchNames.put("Otm4-A", QuadBoxSwitches.SW_OTM_4_A);
        switchNames.put("Otm4-B", QuadBoxSwitches.SW_OTM_4_B);
        switchNames.put("Otm5-A", QuadBoxSwitches.SW_OTM_5_A);
        switchNames.put("Otm5-B", QuadBoxSwitches.SW_OTM_5_B);
        switchNames.put("Main24C", QuadBoxSwitches.SW_MAIN_24C);
        switchNames.put("PowerCryoHCUs", QuadBoxSwitches.SW_HCU_PWR_CRY);
        switchNames.put("FesShutterHCUs", QuadBoxSwitches.SW_HCU_FES_SHU);
        switchNames.put("IonPumps", QuadBoxSwitches.SW_ION_PUMPS);
        switchNames.put("BodyPurge", QuadBoxSwitches.SW_BODY_PURGE);
        switchNames.put("BpuMaq20", QuadBoxSwitches.SW_BPU_MAQ20);
        switchNames.put("Gauges", QuadBoxSwitches.SW_GAUGES);
        switchNames.put("FesCarousel", QuadBoxSwitches.SW_FES_CAROUSEL);
        switchNames.put("FesChangerC", QuadBoxSwitches.SW_FES_CHANGER_C);
        switchNames.put("FesLoaderC", QuadBoxSwitches.SW_FES_LOADER_C);
        switchNames.put("Shutter1C", QuadBoxSwitches.SW_SHUTTER_1);
        switchNames.put("Shutter2C", QuadBoxSwitches.SW_SHUTTER_2);
        switchNames.put("Main24D", QuadBoxSwitches.SW_MAIN_24D);
        switchNames.put("CryoTurbo", QuadBoxSwitches.SW_CRYO_TURBO);
        switchNames.put("HexTurbo", QuadBoxSwitches.SW_HEX_TURBO);
        switchNames.put("FesClamps", QuadBoxSwitches.SW_FES_CLAMPS);
        switchNames.put("FesBrake", QuadBoxSwitches.SW_FES_BRAKES);
        switchNames.put("FesChangerD", QuadBoxSwitches.SW_FES_CHANGER_D);
        switchNames.put("FesLoaderD", QuadBoxSwitches.SW_FES_LOADER_D);
        switchNames.put("ShutterBrake", QuadBoxSwitches.SW_SHUTTER_BRAKE);
        switchNames.put("Main48", QuadBoxSwitches.SW_MAIN_48);
        switchNames.put("PurgeFan", QuadBoxSwitches.SW_PURGE_FAN);
        switchNames.put("FesCarouselD", QuadBoxSwitches.SW_FES_CAROUSEL_D);
        switchNames.put("FesHheater", QuadBoxSwitches.SW_FES_HEATER); 
        switchNames.put("Shutter1D", QuadBoxSwitches.SW_SHUTTER_1_D);
        switchNames.put("Shutter2D", QuadBoxSwitches.SW_SHUTTER_2_D );
    }

}
