package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;

/**
 *  Contains the state of an ATS power supply subsystem
 *
 *  @author Owen Saxton
 */
public class ATSPowerState implements Serializable {
    
    public static final String KEY = "ATSPowerState";
    public static final int
        CHAN_DIGITAL  = 0,
        CHAN_ANALOG   = 1,
        CHAN_CLK_HIGH = 2,
        CHAN_CLK_LOW  = 3,
        CHAN_OD       = 4,
        CHAN_HEATER   = 5,
        CHAN_DPHI     = 6,
        CHAN_HV_BIAS  = 7,
        NUM_CHANNELS  = 8;

    private final int tickMillis;         // Data status update period (ms)
    private final Boolean[] powerState;
    private final double hvBias;
    private final double dphi;
 
    public ATSPowerState(int tickMillis, Boolean[] powerState, double dphi, double hvBias)
    {
        this.tickMillis = tickMillis;
        this.powerState = powerState;
        this.hvBias = hvBias;
        this.dphi = dphi;
    }
    
    public int getTickMillis()
    {
        return tickMillis;
    }

    public Boolean[] getPowerState()
    {
        return powerState;
    }

    public double getHvBias()
    {
        return hvBias;
    }

    public double getDphi()
    {
        return dphi;
    }

    private static final long serialVersionUID = 5820563248272906945L;
}
