package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;

/**
 *  Contains information describing the full ATS power supply system state.
 *
 *  Sent on the status bus upon request.
 *
 *  @author Owen Saxton
 */
public class ATSPowerFullState implements Serializable {
    
    private final ATSPowerState atsPowerState;
    private final MonitorFullState monitorState;

    public ATSPowerFullState(ATSPowerState rState, MonitorFullState mState) {
        atsPowerState = rState;
        monitorState = mState;
    }

    public ATSPowerState getATSPowerState() {
        return atsPowerState;
    }

    public MonitorFullState getMonitorFullState() {
        return monitorState;
    }

    private static final long serialVersionUID = -535266890846635668L;
}
