package org.lsst.ccs.subsystem.power.config;

import org.lsst.ccs.drivers.auxelex.RebPs;

/**
 * Enumeration for REB power supply elements
 * 
 * @author  Owen Saxton
 */
public enum RebPsEnum {

    MASTER(-1),
    DIGITAL(RebPs.PS_DIGITAL),
    ANALOG(RebPs.PS_ANALOG),
    OD(RebPs.PS_OD),
    CLOCKHI(RebPs.PS_CLK_HIGH),
    CLOCKLO(RebPs.PS_CLK_LOW),
    HEATER(RebPs.PS_HEATER),
    DPHI(RebPs.PS_DPHI),
    HVBIAS(RebPs.PS_HV_BIAS);

    int number;

    RebPsEnum(int number) {
        this.number = number;
    }

    public int getNumber() {
        return number;
    }

}
