package org.lsst.ccs.subsystem.power.states;

/**
 * Power State for all the Rebs.
 * State transitions are defined based on the configuration parameters stored in
 * variable "powerStateTransitionLimits" in the RebPower class. This array defines
 * the boundaries between the states.
 * 
 * @author The LSST CCS Team
 */
public enum RebPowerState {

    /**
     * Power per Reb is below the lower limit.
     */
    OFF,
    
    /**
     * Power per Reb is at the first level.
     */
    ON,
    
    /**
     * Power per Reb is at the second level.
     */
    LOW_POWER,
    
    /**
     * Power per Reb is above the third level.
     */
    OPERATIONAL;
    
}
