package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;

/**
 ********************************************************
 *
 *  Contains the state of a REB power supply subsystem
 *
 *  @author Owen Saxton
 *
 *********************************************************
 */
public class RebPsState implements Serializable {
    
    public final static String KEY = "RebPsState";

    private final int tickMillis;         // Data status update period (ms)
    private final int mainPowerState;
    private final int[] powerState;
    private final double[] hvBiasDacs;
    private final double[] dphiDacs;
    private final String psId;
 
    public RebPsState(int tickMillis, int mainPowerState, int[] powerState,
                      double[] hvBiasDacs, double[] dphiDacs, String psId)
    {
        this.tickMillis = tickMillis;
        this.mainPowerState = mainPowerState;
        this.powerState = powerState;
        this.hvBiasDacs = hvBiasDacs;
        this.dphiDacs = dphiDacs;
        this.psId = psId;
    }
    
    public int getTickMillis()
    {
        return tickMillis;
    }

    public int getMainPowerState()
    {
        return mainPowerState;
    }

    public int[] getPowerState()
    {
        return powerState;
    }

    public double[] getHvBiasDacs()
    {
        return hvBiasDacs;
    }

    public double[] getDphiDacs()
    {
        return dphiDacs;
    }

    public String getpsId()
    {
        return psId;
    }

    private static final long serialVersionUID = -6821718696215793794L;
}
