package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;

/**
 ***************************************************************************
 **
 **  Contains information describing the full power supply state.
 **
 **  Sent on the status bus upon request.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class PowerFullState implements Serializable {
    
    private final PowerState powerState;
    private final MonitorFullState monitorState;

    public PowerFullState(PowerState pState, MonitorFullState mState) {
        powerState = pState;
        monitorState = mState;
    }

    public PowerState getPowerState() {
        return powerState;
    }

    public MonitorFullState getMonitorFullState() {
        return monitorState;
    }

    private static final long serialVersionUID = 8768125741860751698L;
}
