package org.lsst.ccs.subsystem.power.config;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Contains a set of power configuration values.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class Power implements Serializable {

    private String name;
    private ConnType connType;
    private String devcId;
    private int devcParm;
    private Channel[] channels;

    public static enum ConnType {

        Network, Ftdi, Serial;
    }

    public static class Channel implements Serializable {

        private String name;
        private double voltage;
        private double current;
        private double onDelay;
        private double offDelay;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getVoltage() {
            return voltage;
        }

        public void setVoltage(double voltage) {
            this.voltage = voltage;
        }

        public double getCurrent() {
            return current;
        }

        public void setCurrent(double current) {
            this.current = current;
        }

        public double getOnDelay() {
            return onDelay;
        }

        public void setOnDelay(double onDelay) {
            this.onDelay = onDelay;
        }

        public double getOffDelay() {
            return offDelay;
        }

        public void setOffDelay(double offDelay) {
            this.offDelay = offDelay;
        }

        private static final long serialVersionUID = -2199926246558369020L;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConnType getConnType() {
        return connType;
    }

    public void setConnType(ConnType connType) {
        this.connType = connType;
    }

    public String getDevcId() {
        return devcId;
    }

    public void setDevcId(String devcId) {
        this.devcId = devcId;
    }

    public int getDevcParm() {
        return devcParm;
    }

    public void setDevcParm(int devcParm) {
        this.devcParm = devcParm;
    }

    public Channel[] getChannels() {
        return channels;
    }

    public void setChannels(Channel[] channels) {
        this.channels = channels;
    }

    private static final long serialVersionUID = -5518945401026297319L;
}
