/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCacheMonitor;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheFactory;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.remote.RemoteLocation;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.engine.CacheStatus;

public class RemoteCacheFailoverRunner<K, V>
extends AbstractAuxiliaryCacheMonitor {
    private final RemoteCacheNoWaitFacade<K, V> facade;
    private final RemoteCacheFactory cacheFactory;

    public RemoteCacheFailoverRunner(RemoteCacheNoWaitFacade<K, V> facade, RemoteCacheFactory cacheFactory) {
        super("JCS-RemoteCacheFailoverRunner");
        this.facade = facade;
        this.cacheFactory = cacheFactory;
        RemoteCacheFailoverRunner.setIdlePeriod(20000L);
    }

    @Override
    protected void dispose() {
    }

    @Override
    protected void doWork() {
    }

    @Override
    public void run() {
        this.connectAndRestore();
        if (this.log.isInfoEnabled()) {
            int failoverIndex = this.facade.getAuxiliaryCacheAttributes().getFailoverIndex();
            this.log.info("Exiting failover runner. Failover index = {0}", failoverIndex);
            if (failoverIndex <= 0) {
                this.log.info("Failover index is <= 0, meaning we are not connected to a failover server.");
            } else if (failoverIndex > 0) {
                this.log.info("Failover index is > 0, meaning we are connected to a failover server.");
            }
        }
    }

    private void connectAndRestore() {
        IRemoteCacheAttributes rca0 = this.facade.getAuxiliaryCacheAttributes();
        do {
            this.log.info("Remote cache FAILOVER RUNNING.");
            if (!this.allright.get()) {
                List<RemoteLocation> failovers = rca0.getFailovers();
                if (failovers == null) {
                    this.log.warn("Remote is misconfigured, failovers was null.");
                    return;
                }
                if (failovers.size() == 1) {
                    this.log.info("No failovers defined, exiting failover runner.");
                    return;
                }
                int fidx = rca0.getFailoverIndex();
                this.log.debug("fidx = {0} failovers.size = {1}", () -> fidx, () -> failovers.size());
                ListIterator<RemoteLocation> i = failovers.listIterator(fidx);
                this.log.debug("starting at failover i = {0}", i);
                while (i.hasNext() && !this.allright.get()) {
                    RemoteCacheNoWait ic;
                    RemoteLocation server = i.next();
                    this.log.debug("Trying server [{0}] at failover index i = {1}", server, i);
                    RemoteCacheAttributes rca = (RemoteCacheAttributes)rca0.clone();
                    rca.setRemoteLocation(server);
                    RemoteCacheManager rcm = this.cacheFactory.getManager(rca);
                    this.log.debug("RemoteCacheAttributes for failover = {0}", rca);
                    if (rcm == null || (ic = rcm.getCache(rca)).getStatus() != CacheStatus.ALIVE) continue;
                    this.log.debug("resetting no wait");
                    this.facade.restorePrimaryServer(ic);
                    rca0.setFailoverIndex(i.nextIndex());
                    this.log.debug("setting ALLRIGHT to true");
                    if (i.hasPrevious()) {
                        this.log.debug("Moving to Primary Recovery Mode, failover index = {0}", i);
                    } else {
                        this.log.debug("No need to connect to failover, the primary server is back up.");
                    }
                    this.allright.set(true);
                    this.log.info("CONNECTED to host = [{0}]", () -> rca.getRemoteLocation());
                }
            } else {
                this.log.debug("ALLRIGHT is true ");
                this.log.info("Failover runner is in primary recovery mode. Failover index = {0} Will now try to reconnect to primary server.", () -> rca0.getFailoverIndex());
            }
            boolean primaryRestoredSuccessfully = false;
            if (rca0.getFailoverIndex() > 0) {
                primaryRestoredSuccessfully = this.restorePrimary();
                this.log.debug("Primary recovery success state = {0}", primaryRestoredSuccessfully);
            }
            if (primaryRestoredSuccessfully) continue;
            try {
                this.log.warn("Failed to reconnect to primary server. Cache failover runner is going to sleep for {0} milliseconds.", idlePeriod);
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (rca0.getFailoverIndex() > 0 || !this.allright.get());
    }

    private boolean restorePrimary() {
        RemoteCacheNoWait ic;
        IRemoteCacheAttributes rca0 = this.facade.getAuxiliaryCacheAttributes();
        RemoteLocation server = rca0.getFailovers().get(0);
        this.log.info("Trying to restore connection to primary remote server [{0}]", server);
        RemoteCacheAttributes rca = (RemoteCacheAttributes)rca0.clone();
        rca.setRemoteLocation(server);
        RemoteCacheManager rcm = this.cacheFactory.getManager(rca);
        if (rcm != null && (ic = rcm.getCache(rca)).getStatus() == CacheStatus.ALIVE) {
            try {
                if (this.facade.getPrimaryServer() != null && this.facade.getPrimaryServer().getStatus() == CacheStatus.ALIVE) {
                    int fidx = rca0.getFailoverIndex();
                    if (fidx > 0) {
                        RemoteLocation serverOld = rca0.getFailovers().get(fidx);
                        this.log.debug("Failover Index = {0} the server at that index is [{1}]", fidx, serverOld);
                        if (serverOld != null) {
                            RemoteCacheAttributes rcaOld = (RemoteCacheAttributes)rca0.clone();
                            rcaOld.setRemoteLocation(serverOld);
                            RemoteCacheManager rcmOld = this.cacheFactory.getManager(rcaOld);
                            if (rcmOld != null) {
                                rcmOld.removeRemoteCacheListener(rcaOld);
                            }
                            this.log.info("Successfully deregistered from FAILOVER remote server = {0}", serverOld);
                        }
                    } else if (fidx == 0) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("No need to restore primary, it is already restored.");
                            return true;
                        }
                    } else if (fidx < 0) {
                        this.log.warn("Failover index is less than 0, this shouldn't happen");
                    }
                }
            }
            catch (IOException e) {
                this.log.error("Trouble trying to deregister old failover listener prior to restoring the primary = {0}", server, e);
            }
            RemoteCacheNoWait failoverNoWait = this.facade.getPrimaryServer();
            this.facade.restorePrimaryServer(ic);
            rca0.setFailoverIndex(0);
            String message = "Successfully reconnected to PRIMARY remote server. Substituted primary for failoverNoWait [" + failoverNoWait + "]";
            this.log.info(message);
            if (this.facade.getCacheEventLogger() != null) {
                this.facade.getCacheEventLogger().logApplicationEvent("RemoteCacheFailoverRunner", "RestoredPrimary", message);
            }
            return true;
        }
        this.log.debug("Primary server status in error, not connected.");
        return false;
    }
}

