import org.lsst.ccs.description.groovy.CCSBuilder;

import org.lsst.ccs.subsystem.common.devices.turbopump.*;
import org.lsst.ccs.subsystem.common.devices.refrigeration.*;
import org.lsst.ccs.subsystem.common.devices.refrigeration.data.RefrigerationConfig
import org.lsst.ccs.subsystem.common.devices.vacuum.*;
import org.lsst.ccs.subsystem.common.devices.power.distribution.*;

import org.lsst.ccs.subsystem.pathfinder.VacPlutoDevice;
import org.lsst.ccs.subsystem.pathfinder.IonPumpDevice;
import org.lsst.ccs.subsystem.pathfinder.IonPumpControl;
import org.lsst.ccs.subsystem.pathfinder.FanPIControl
import org.lsst.ccs.subsystem.pathfinder.Maq20DevicePF;
import org.lsst.ccs.subsystem.pathfinder.Maq20DeviceUT;
//import org.lsst.ccs.subsystem.pathfinder.UTMaq20PWMControl;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PWMControl;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PulseControl;
import org.lsst.ccs.subsystem.pathfinder.SimUTMaq20PWMControl;

import org.lsst.ccs.subsystem.pathfinder.WeightedAverageChannel;

//import org.lsst.ccs.subsystem.pathfinder.CryoTurboDevice;
import org.lsst.ccs.subsystem.pathfinder.data.VacSysState;

import org.lsst.ccs.subsystem.pathfinder.Mks9xxDevice;

import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20AnalogControl

import org.lsst.ccs.subsystem.pathfinder.data.*;
import org.lsst.ccs.subsystem.pathfinder.*;
import org.lsst.ccs.subsystem.pathfinder.alerts.PathfinderAlerts;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

import org.lsst.ccs.subsystem.pathfinder.SuperHeatChannel

//import org.lsst.ccs.subsystem.refrig.TrimHeaterControl
//import org.lsst.ccs.subsystem.refrig.HeaterPsDevice


import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["pathfinder"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()

def runMode = props.getProperty("org.lsst.ccs.run.mode","normal");
if (runMode.equals("simulation")) {
    maq20Device = SimMaq20Device
    maq20DevicePF = SimMaq20Device
    maq20DeviceUT = SimMaq20Device
    compMaq20PWMControl = SimUTMaq20PWMControl
    pOffset500 = 0.0
    pScale500 = 1.0
    pOffset750 = 0.0
    pScale750 = 1.0
    thermalSubsys = "thermal-sim"
}
else {
    maq20Device = Maq20Device
    maq20DevicePF = Maq20DevicePF
    maq20DeviceUT = Maq20DeviceUT
    compMaq20PWMControl = Maq20PWMControl
    maq20AnalogControl = Maq20AnalogControl
    maq20DeviceOth = Maq20Device
    pOffset500 = -125.0;
    pScale500 = 31250.0
    pOffset750 = -187.5
    pScale750 = 46875.0
    thermalSubsys = "thermal"
}


//Class turboClass = Class.forName("org.lsst.ccs.common.devices.turbopump.TwisTorr84" + "Device");

taskConfig = ["monitor-update/taskPeriodMillis":3000,"monitor-publish/taskPeriodMillis":3000]

builder.

    main (PathfinderSubsystem, utFan: ref("UTFan"), utFanSpeed: ref("UT/FanSpeed"), nodeTags:taskConfig, pressChan1:"GaugeGCC00/pfpressure", forelinePressChan:"GaugeGCC02/forelinepressure", turboPressChan:"GaugeGCC01/turbopressure", turboSpeedChan:"turbo/rpm",

        switches:[
        VacSysState.SW_HX_VALVE,
        VacSysState.SW_HX_TURBO,
	VacSysState.SW_HX_ION_PUMP1
/*
        VacSysState.SW_BLOCK_HVSTAT,
        VacSysState.SW_BLOCK_CVSTAT,
        VacSysState.SW_OPEN_VHX00,
        VacSysState.SW_OPEN_VCR00,
        VacSysState.SW_OPEN_VCR01,
        VacSysState.SW_OPEN_VCR02,
        VacSysState.SW_OPEN_VCR03,
        VacSysState.SW_OPEN_VCR04,
        VacSysState.SW_BLOCK_HVPUMP,
        VacSysState.SW_BLOCK_CVPUMP
*/
                    ]) {

    PathfinderAlertHandler (PathfinderAlertHandler)


    VacuumPLCNotAlive (Alarm, description:"Vacuum PLC not alive", eventParm:PathfinderAlerts.VACUUM_PLC_NOT_ALIVE.ordinal())
    AlarmHxVacuumBad (Alarm, description:"HX Vacuum Bad", eventParm:PathfinderAlerts.HX_VACUUM_BAD.ordinal())
    AlarmHxGateForcedShut (Alarm, description:"HX Gate Valve Forced Shut", eventParm:PathfinderAlerts.HX_GATE_FORCED_SHUT.ordinal())
    AlarmHxGateCannotOpen (Alarm, description:"HX Gate Valve Cannot Open", eventParm:PathfinderAlerts.HX_GATE_CANNOT_OPEN.ordinal())
    AlarmHxTurboPumpBad (Alarm, description:"HX Turbo Pump Bad", eventParm:PathfinderAlerts.HX_TURBO_PUMP_BAD.ordinal())
    AlarmPressureLow (Alarm, description:"Alert raised when the pressure too low", eventParm:PathfinderAlerts.HX_TURBO_PUMP_BAD.ordinal())
    AlarmPressureHigh (Alarm, description:"Alert raised when the pressure too high", eventParm:PathfinderAlerts.PRESSURE_TOO_LOW.ordinal())
    AlarmVacuumValveShutOff (Alarm, description:"Alert raised when the vacuum valve is shut off", eventParm:PathfinderAlerts.PRESSURE_TOO_HIGH.ordinal())
    AlarmUPSOnBattery (Alarm, description:"Alert raised when UPS goes onto battery", eventParm:PathfinderAlerts.UPS_ON_BATTERY.ordinal())
    AlarmUPSDisconnected (Alarm, description:"Alert raised when UPS becomes disconnected", eventParm:PathfinderAlerts.UPS_DISCONNECTED.ordinal())
    AlarmTurboPumpFailure (Alarm, description:"Alert raised when TurboPump status is Fail", eventParm:PathfinderAlerts.TURBO_PUMP_FAIL.ordinal())
    AlarmTurboPumpOverTemp (Alarm, description:"Alert raised when TurboPump temperature is too high", eventParm:PathfinderAlerts.TURBO_PUMP_OVERTEMP.ordinal()) 
    AlarmLoadRTDOverTemp (Alarm, description:"Alert raised when a load RTD temperature is too high", eventParm:PathfinderAlerts.LOAD_RTD_OVERTEMP.ordinal()) 
    AlarmGeneric (Alarm, description:"Generic Alert", eventParm:PathfinderAlerts.GENERIC.ordinal())


    UTFlowAlarm (Alarm, description: "UT Coolant flow alarm")

    UTTempLoAlarm (Alarm, description: "UT Low temperature alarm")

    UTTempHiAlarm (Alarm, description: "UT High temperature alarm")

    UTSpeedHiAlarm (Alarm, description: "UT High fan speed alarm")


    maq20_pth (maq20DeviceUT, modules: ["DOUT", "DINP", "DINP", "DIOL:pwm:pulse"]) {
       UTPwm (compMaq20PWMControl, modIndex: 3, funcIndex: 0, frequency: 200.0)
       UTPulse (Maq20PulseControl, modIndex: 3, funcIndex: 1, pulsesPerRevn: 6)

    }

    "UT/FanSpeed" (Channel, description: "UT fan speed", units: "rpm", format: ".0f",
        devcName: "maq20_pth", hwChan: Maq20DeviceUT.CHAN_PULSE_RPM, type: "3", subtype: "1",
        checkHi: "alarm", alarmHi: "UTSpeedHiAlarm")




//    TrimPower  (HeaterPsDevice, softMaxCurrent: 1.95)


// 1
     GaugeGCC01 (Mks9xxDevice, devcId:"/dev/serial/by-id/usb-FTDI_USB__-__Serial_Converter_FT2GWUWE-if01-port0", busAddr:252) {
        turbopressure  (Channel, description:"Pressure Reading", units:"Torr", format:".3G",
                      hwChan:0,
                    limitLo:0.0, dbandLo:0.00000001, checkLo:"alarm", alarmLo:"AlarmPressureLow",
                    checkHi:"alarm", limitHi:810.0, dbandHi:20.0, alarmHi:"AlarmPressureHigh")
    }

// 2
     GaugeGCC00 (Mks9xxDevice, devcId:"/dev/serial/by-id/usb-FTDI_USB__-__Serial_Converter_FT2GWUWE-if01-port0", busAddr:251) {
        pfpressure  (Channel, description:"Pressure Reading", units:"Torr", format:".3G",
                      hwChan:0,
                    limitLo:0.0, dbandLo:0.00000001, checkLo:"alarm", alarmLo:"AlarmPressureLow",
                    checkHi:"alarm", limitHi:810.0, dbandHi:20.0, alarmHi:"AlarmPressureHigh")
    }
// 3
     GaugeGCC02 (Mks9xxDevice, devcId:"/dev/serial/by-id/usb-FTDI_USB__-__Serial_Converter_FT2GWUWE-if01-port0", busAddr:250) {
        forelinepressure  (Channel, description:"Pressure Reading", units:"Torr", format:".3G",
                      hwChan:0,
                    limitLo:0.0, dbandLo:0.00000001, checkLo:"alarm", alarmLo:"AlarmPressureLow",
                    checkHi:"alarm", limitHi:810.0, dbandHi:20.0, alarmHi:"AlarmPressureHigh")
    }

/*
>> showmodules                                                                                                        
ID  Type  Serial No.
 1  RTD   0124186-09
 2  RTD   0126432-12
 3  RTD   0121348-05
 4  IS    0123738-05
 5  IS    0120610-03
 6  RTD   0124186-05
 */

    
    turbo  (CryoTurboDevice, devcId:"/dev/serial/by-id/usb-FTDI_USB__-__Serial_Converter_FT2GWUWE-if02-port0", lowSpeedMode:false, waterCooling:false,
            ventValveByCmnd:true, interlockType:true, softStartMode:true,
            activeStopMode:true, model304:false) {




    "current"      (Channel, description:"TurboPump current", units:"mA",
                       type:"Numeric", subtype:"CURRENT",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    "voltage"      (Channel, description:"TurboPump voltage", units:"Volt",
                       type:"Numeric", subtype:"VOLTAGE",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    "power"        (Channel, description:"TurboPump power", units:"Watt",
                       type:"Numeric", subtype:"POWER",
                       checkLo:"none", checkHi:"alarm", format:"%.0f",
                       limitHi:71.0, dbandHi:31.0, alarmHi:"AlarmGeneric")

    "driveFrequency"    (Channel, description:"TurboPump drive frequency", units:"Hz",
                       type:"Numeric", subtype:"DRIVEFREQ",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    "pumpTemperature"     (Channel, description:"TurboPump pump temperature", 
                       units:"\u00b0C", 
                       type:"Numeric", subtype:"PUMP_TEMP", format:"%.0f",
                       limitLo:0.0, checkLo:"flag", dbandLo:5.0, 
                       limitHi:35.0, checkHi:"alarm", dbandHi:5.0, 
                       alarmHi:"AlarmTurboPumpOverTemp")

    "cntrlrSinkTemperature" (Channel, description:"TurboPump controller sink temp.", 
                       units:"\u00b0C", 
                       type:"Numeric", subtype:"CONT_TEMP_SINK", format:"%.0f",
                       limitLo:0.0, checkLo:"flag", dbandLo:5.0, 
                       limitHi:35.0, checkHi:"alarm", dbandHi:5.0, 
                       alarmHi:"AlarmTurboPumpOverTemp")

    "cntrlrAirTemperature"  (Channel, description:"TurboPump controller air temp.", 
                       units:"\u00b0C", 
                       type:"Numeric", subtype:"CONT_TEMP_AIR", format:"%.0f",
                       limitLo:0.0, checkLo:"flag", dbandLo:5.0, 
                       limitHi:35.0, checkHi:"alarm", dbandHi:5.0, 
                       alarmHi:"AlarmTurboPumpOverTemp")

    "rpm"          (Channel, description:"TurboPump speed in RPM", units:"unitless",
                       type:"Numeric", subtype:"RPM",
                       checkLo:"none", checkHi:"none", format:"%.0f")

    "status"       (Channel, description:"TurboPump status: 5=normal, 6=fail", units:"unitless", 
                       type:"Numeric", subtype:"STATUS", 
                       format:"%.0f",
                       limitLo:-0.5, checkLo:"flag", dbandLo:5.0, limitHi:5.5,
                       checkHi:"alarm", alarmHi:"AlarmTurboPumpFailure")




    }





     /*
         Its name, used to identify it in databases, plots, etc.
    Its longer, more descriptive, name.
    The units the value is expressed in, e.g. "Volt".
    The device used for obtaining its value.
    The hardware channel number on the device.
    The channel type, e.g. temperature, pressure, etc, which is needed by some devices.
    The subtype, which supplies hardware configuration information.
    The offset and scale values needed for converting a raw hardware value to a physical one.
    Parameters used for checking the value against a limit.  There is one set for the low limit and one for the high one:
        The checking option: NONE, FLAG or ALARM
        The limit value.
        The alarm to be activated upon status transitions when ALARM is specified.
        The deadband value which delays a potential alarm action during a transition back to good status.
    Its id, which is its index in the list of all channels.

The limit values are maintained by the configuration system and can be changed while running.  Any such change causes a status message to be broadcast, which can be used to update the trending database or to update any console displays.
*/



/* ===
        latchNames[VacSysState.LATCH_CR_GATE_AO]  = "Cryo Gate Can't Open";
        latchNames[VacSysState.LATCH_CR_GATE_NFC] = "Cryo Gate Forced Shut";
        latchNames[VacSysState.LATCH_CR_VACUUM]   = "Cryo Vacuum Bad";
        latchNames[VacSysState.LATCH_CR_PUMP]     = "Cryo Turbo Pump Bad";
        latchNames[VacSysState.LATCH_HX_GATE_AO]  = "Hx Gate Can't Open";
        latchNames[VacSysState.LATCH_HX_GATE_NFC] = "Hx Gate Forced Shut";
        latchNames[VacSysState.LATCH_HX_VACUUM]   = "Hx Vacuum Bad";
        latchNames[VacSysState.LATCH_HX_PUMP]     = "Hx Turbo Pump Bad";
== */





    VacPluto (VacPlutoDevice, node:"192.168.1.131",
/*
              latchesUsed:[VacSysState.LATCH_CR_GATE_AO, VacSysState.LATCH_CR_GATE_NFC,
                           VacSysState.LATCH_CR_PUMP, VacSysState.LATCH_CR_VACUUM,
							   VacSysState.LATCH_HX_VACUUM],
*/
              latchesUsed:[VacSysState.LATCH_HX_VACUUM, VacSysState.LATCH_HX_PUMP, VacSysState.LATCH_HX_GATE_AO, VacSysState.LATCH_HX_GATE_NFC],
              condsUsed:[VacSysState.COND_CR_FORELINE_VAC, VacSysState.COND_CR_TRB_PRESS_10,
                         VacSysState.COND_CR_TRB_PUMP_OFF, VacSysState.COND_CR_VACUUM_001,
                         VacSysState.COND_CR_VACUUM_01, VacSysState.COND_HX_TURBO_OFF, VacSysState.COND_HX_VACUUM_001,
								 VacSysState.COND_HX_VACUUM_01, VacSysState.COND_HX_FORELINE_VAC])
/*
              latchesUsed:[VacSysState.LATCH_HX_VACUUM],
              condsUsed:[VacSysState.COND_HX_VACUUM_001,
                         VacSysState.COND_HX_VACUUM_01,
                         VacSysState.COND_HX_FORELINE_VAC])
*/

    int cip2 = IonPumpDevice.CHAN_CIP2
    int hip1 = IonPumpDevice.CHAN_HIP1
    int hip2 = IonPumpDevice.CHAN_HIP2
    int oip  = IonPumpDevice.CHAN_OIP

    IonPumps (IonPumpDevice, ipAddr:"192.168.1.87") {

        CIP1C (IonPumpControl, hwChan:cip2, voltage:5000, current:0.002, power:9.9)

        "current" (Channel, description:"Cryo ion pump current", units:"mA",
                hwChan:cip2, type:"CURRENT", scale:1000.0, limitHi:3.2, dbandHi:1.6)

        "voltage" (Channel, description:"Cryo ion pump voltage", units:"Volt", format:".1f",
                hwChan:cip2, type:"VOLTAGE")

    }




// 1 TTC  0131744-05
// 2 IS  0130197-04
// 3 IO  0136788-02

   maq20_bpu (maq20DevicePF, modules: ["TTC", "IS", "IO", "RTD"]) {

       AnalogOut (maq20AnalogControl, modIndex: 2, ranges: ["MA4_20", "MA4_20", "MA4_20"])

       FlowMeter (Channel, description: "flow meter", units: "g/min", format: ".1f",
                         devcName: "maq20_bpu", hwChan: 10, type: "1", subtype: "MA4_20", offset: pOffset500, scale: pScale500)
       "UTC-CMC-THC-00" (Channel, description: "UTC-CMC-THC-00 Temp", units: "\u00b0C", format: ".1f",
                          devcName: "maq20_bpu", hwChan: 0, type: "0", subtype: "T220")
       "UTC-CMC-THC-01" (Channel, description: "UTC-CMC-THC-01 Temp", units: "\u00b0C", format: ".1f",
                          devcName: "maq20_bpu", hwChan: 1, type: "0", subtype: "T220")
       "UTC-CMC-THC-02" (Channel, description: "UTC-CMC-THC-02 Temp", units: "\u00b0C", format: ".1f",
                          devcName: "maq20_bpu", hwChan: 2, type: "0", subtype: "T220")
       "UTC-CMC-THC-03" (Channel, description: "UTC-CMC-THC-03 Temp", units: "\u00b0C", format: ".1f",
                          devcName: "maq20_bpu", hwChan: 3, type: "0", subtype: "T220")
    }

//ID  Type  Serial No.
// 1  IO    0136788-02
// 2  RTD   0143400-15
// 3  IS    0130197-04
// 4  TTC   0131744-05
/*
   maq20_oth (maq20DeviceOth, modules: ["IO"."RTD", "IS", "TTC"]) {

            T1 (Channel, description: "Primary Oil Separator Temp", units: "\u00b0C", format: ".1f",
                          devcName: maq20_oth, hwChan: 2, type: "3", subtype: "T220")

            T2  (Channel, description: "Phase Separator Temperature", units: "\u00b0C", format: ".1f",
                          devcName: maq20_oth, hwChan: 5, type: "3", subtype: "T220")

            T3    (Channel, description: "Oil Separator Temperature", units: "\u00b0C", format: ".1f",
                          devcName: maq20_oth, hwChan: 6, type: "3", subtype: "T220")


            T4 (Channel, description: "Secondary Oil Separator Temp", units: "\u00b0C", format: ".1f",
                          devcName: maq20_oth, hwChan: 7, type: "3", subtype: "T220")

    }
*/


    maq20       (Maq20Device, modules: ["RTD", "RTD", "RTD", "IS", "IS", "RTD", "RTD"]) { // first 3 RTD modules are for HEX
/*
      		"HEXRTDS" (Channel, description: "HEXRTDs", units: "\u00b0C", format: ".1f",
                                devcName: "HexRTDs", hwChan: 0, type: "1", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
			        checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")
*/
      "Cryo1/C3ExitTmp" (Channel, description: "C3 EXIT", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 0, type: "0", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cryo1/PreC3Tmp" (Channel, description: "PRE C3", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 1, type: "0", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cryo1/PreC4Tmp" (Channel, description: "PRE C4", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 2, type: "0", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cryo1/C4ExitTmp" (Channel, description: "C4 EXIT", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 3, type: "0", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cryo1/EvapExitTmp" (Channel, description: "EVAP EXIT", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 4, type: "0", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cryo1/HexRtrnTmp" (Channel, description: "HEX RTRN", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 5, type: "0", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

// -------------------------------------------------------------------------------------



      "Cryo2/C3ExitTmp" (Channel, description: "C3 EXIT", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 0, type: "5", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cryo2/PreC3Tmp" (Channel, description: "PRE C3", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 1, type: "5", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cryo2/PreC4Tmp" (Channel, description: "PRE C4", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 2, type: "5", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cryo2/C4ExitTmp" (Channel, description: "C4 EXIT", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 3, type: "5", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cryo2/EvapExitTmp" (Channel, description: "EVAP EXIT", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 4, type: "5", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cryo2/HexRtrnTmp" (Channel, description: "HEX RTRN", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 5, type: "5", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

// -------------------------------------------------------------------------------------


      "REF-LOAD-RTD-06" (Channel, description: "CRYO TOP", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 3, type: "6", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:65.0, dbandHi:10.0, alarmHi:"AlarmLoadRTDOverTemp")

      "REF-LOAD-RTD-07" (Channel, description: "CRYO BOTT", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 4, type: "6", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:65.0, dbandHi:10.0, alarmHi:"AlarmLoadRTDOverTemp")

      "REF-LOAD-RTD-08" (Channel, description: "CRYO -XSIDE", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 5, type: "6", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:65.0, dbandHi:10.0, alarmHi:"AlarmLoadRTDOverTemp")


//-- -- -- -- -- -- 

      "Cold1/PreExpnTmp" (Channel, description: "PRE-EXPN", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 0, type: "2", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cold1/EvapExitTmp" (Channel, description: "EVAP EXIT", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 1, type: "2", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cold1/HexRtrnTmp" (Channel, description: "HEX RTRN", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 2, type: "2", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")
//--
      "Cold2/PreExpnTmp" (Channel, description: "PRE-EXPN", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 3, type: "2", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cold2/EvapExitTmp" (Channel, description: "EVAP EXIT", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 4, type: "2", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

      "Cold2/HexRtrnTmp" (Channel, description: "HEX RTRN", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 5, type: "2", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:25.0, dbandHi:0.0, alarmHi:"AlarmGeneric")

// -------------------------------------------------------------------------------------



      "REF-LOAD-RTD-00" (Channel, description: "EVAP ENTR UPR", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 0, type: "1", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:65.0, dbandHi:10.0, alarmHi:"AlarmLoadRTDOverTemp")

      "REF-LOAD-RTD-01" (Channel, description: "EVAP ENTR LWR", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 1, type: "1", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:65.0, dbandHi:10.0, alarmHi:"AlarmLoadRTDOverTemp")

      "REF-LOAD-RTD-02" (Channel, description: "COLD TOP", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 2, type: "1", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:65.0, dbandHi:10.0, alarmHi:"AlarmLoadRTDOverTemp")

      "REF-LOAD-RTD-03" (Channel, description: "COLD BOTT", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 3, type: "1", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:65.0, dbandHi:10.0, alarmHi:"AlarmLoadRTDOverTemp")

      "REF-LOAD-RTD-04" (Channel, description: "COLD +XSIDE", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 4, type: "1", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:65.0, dbandHi:10.0, alarmHi:"AlarmLoadRTDOverTemp")

      "REF-LOAD-RTD-05" (Channel, description: "COLD -XSIDE", units: "u00b0C", format: ".1f",
                                devcName: "maq20", hwChan: 5, type: "1", subtype: "R200",
                                checkLo:"alarm", limitLo:-65.0, dbandLo:0.0, alarmLo:"AlarmGeneric",
                                checkHi:"alarm", limitHi:65.0, dbandHi:10.0, alarmHi:"AlarmLoadRTDOverTemp")


//    EvapPress (EvaporatorPressDevice, returnPressChans: ["Cold1/ReturnPrs", "Cold2/ReturnPrs"],
//               thermalSubsysName: thermalSubsys, coldRtdChans: ["Cold_Temp/CLP-RTD-50", "Cold_Temp/CLP-RTD-55"])

/*   -- old ----
    "Cold1/PreExpnTmp"  (Channel, description: "Pre Expn Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "maq20", hwChan: 0, type: "6", subtype: "R200")

    "Cold1/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "maq20", hwChan: 1, type: "6", subtype: "R200")

    "Cold1/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: "maq20", hwChan: 2, type: "6", subtype: "R200")
*/

 
// -------------------------- Cold1 -------------------
   "Cold1/SupplyPrs"   (Channel, description: "Supply Pressure", units: "psia", format: ".1f",
                         devcName: "maq20", hwChan: 2, type: "3", subtype: "MA4_20", offset: pOffset500, scale: pScale500)

    "Cold1/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: "maq20", hwChan: 3, type: "3", subtype: "MA4_20", offset: pOffset500, scale: pScale500)

//    "Cold1/EvapDeltaPrs" (Channel, description: "Evap Delta Pressure", units: "psia", format: ".1f",
//                          devcName: "EvapPress", hwChan: EvaporatorPressDevice.CHAN_COLD1)

    "Cold1/SuperHeat"   (SuperHeatChannel, description: "Cold1 SuperHeat", units: "\u00b0C", format: ".2f",
                        devcName: "maq20", evapExitTempChannel: ref("Cold1/EvapExitTmp"), returnPressureChannel:ref("Cold1/ReturnPrs"))
// -------------------------- Cold2 -------------------
   "Cold2/SupplyPrs"   (Channel, description: "Supply Pressure", units: "psia", format: ".1f",
                         devcName: "maq20", hwChan: 4, type: "3", subtype: "MA4_20", offset: pOffset500, scale: pScale500)

    "Cold2/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: "maq20", hwChan: 5, type: "3", subtype: "MA4_20", offset: pOffset500, scale: pScale500)

//    "Cold2/EvapDeltaPrs" (Channel, description: "Evap Delta Pressure", units: "psia", format: ".1f",
//                          devcName: "EvapPress", hwChan: EvaporatorPressDevice.CHAN_COLD1)

    "Cold2/SuperHeat"   (SuperHeatChannel, description: "Cold2 SuperHeat", units: "\u00b0C", format: ".2f",
                        devcName: "maq20", evapExitTempChannel: ref("Cold2/EvapExitTmp"), returnPressureChannel:ref("Cold2/ReturnPrs"))



/*
    "Cold1/SupplyTmp"   (Channel, description: "Supply Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20x, hwChan: 4, type: "0", subtype: "T220")

    "Cold1/SupplySubCooling" (SubCoolingChannel, description: "Cold1 Supply SubCooling", units: "\u00b0C", format: ".2f",
                              dischargePressureChannel: ref("Cold1/SupplyPrs"), liquidTempChannel:ref("Cold1/SupplyTmp"))

    "Cold1/EnthalpyExch" (EnthalpyExchangeChannel, description: "Enthalpy Exchange", units: "kJ/kG", format: ".2f",
                          supplyTempChannel: ref("Cold1/SupplyTmp"), preExpnTempChannel: ref("Cold1/PreExpnTmp"),
                          r507aSpecHeat: 1.43)
*/

    }


    "UT/AverageTemp" (WeightedAverageChannel, description: "UT weighted average temperature", units: "\u00b0C",
                      channels: [ref("maq20_bpu/UTC-CMC-THC-00"), ref("maq20_bpu/UTC-CMC-THC-01"),
                                 ref("maq20_bpu/UTC-CMC-THC-02"), ref("maq20_bpu/UTC-CMC-THC-03")],
                      weights: [2.0, 2.0, 2.0, 2.0])
     UTFan   (FanPIControl, fan: ref("maq20_pth/UTPwm"), refTempChans: ["turbo/cntrlrAirTemperature"],
             ctrlTempChans: [ref("UT/AverageTemp")], ctrlTempWeights: [1.0])



}