package org.lsst.ccs.subsystem.pathfinder;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PWMControl;

/**
 *  UT extension to MAQ20 PWM control.
 * 
 *  @author saxton
 */
public class UTMaq20PWMControl extends Maq20PWMControl {

    private boolean disabled = false;


    /**
     *  Disables the duty cycle setting.
     */
    public void disable()
    {
        disabled = true;
    }


    /**
     *  Enables the duty cycle setting.
     */
    public void enable()
    {
        disabled = false;
    }


    /**
     *  Sets duty cycle 1.
     *
     *  If disabled, the duty cycle is set to 0.
     *
     *  @param  duty  The duty cycle (0 - 1)
     *  @throws DriverException
     */
    @Override
    public void setDutyCycle1(double duty) throws DriverException
    {
        super.setDutyCycle1(disabled ? 0.0 : duty);
    }

}
