/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.pathfinder.Maq20DevicePF;

public class PathfinderPowerDevice
extends Device
implements HasLifecycle {
    protected static final int MON_TYPE_POWER = 0;
    protected static final int MON_TYPE_VOLTAGE = 1;
    protected static final int MON_TYPE_CURRENT = 2;
    private static final double TIMEOUT = 2.0;
    private static final String REFRIG = "Refrig";
    protected static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Maq20DevicePF pfControl;
    protected int settlingTime = 100;
    private static final Logger LOG;
    private final String devcName;
    private static final int minChan = 0;
    private static final int maxChan = 1;
    private final Map<Integer, ChannelState> states = new HashMap<Integer, ChannelState>();
    private boolean initError = false;

    public PathfinderPowerDevice(String name) {
        this.devcName = name;
        for (int chan = 0; chan <= 1; ++chan) {
            this.states.put(chan, new ChannelState());
        }
    }

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("maintain-power-" + this.name, () -> this.maintainPower()).withPeriod(Duration.ofMillis(6000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public int getMinChannel() {
        return 0;
    }

    public int getMaxChannel() {
        return 1;
    }

    protected void initDevice() {
        for (int chan = 0; chan <= 1; ++chan) {
            this.states.put(chan, new ChannelState());
        }
        for (int chan : this.states.keySet()) {
            ChannelState state = this.states.get(chan);
            state.enabled = true;
            state.currError = false;
        }
        this.fullName = this.devcName;
    }

    public void postInit() {
        if (this.pfControl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Maq20DevicePF component", (String)"has not been defined");
        }
    }

    protected void initialize() {
        LOG.log(Level.INFO, "Connected to {0}", this.fullName);
        this.initError = false;
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan = ch.getHwChan();
        if (hwChan < 0 || hwChan > 1) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)this.name, (String)"HW channel", (Object)hwChan);
        }
        String type = ch.getTypeStr();
        String name = ch.getName();
        Integer iType = mTypeMap.get(type.toUpperCase());
        if (iType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void setOnline(boolean online) {
        super.setOnline(online);
    }

    public void enableOutput(int chan, boolean enable) {
        ChannelState state = this.getChannelState(chan);
        state.enabled = enable;
        if (!enable) {
            this.pfControl.setHeaterPower(chan, 0.0);
            state.currError = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPower(int heaterId, double fractionPower) {
        ChannelState state;
        ChannelState channelState = state = this.getChannelState(heaterId);
        synchronized (channelState) {
            if (!state.enabled) {
                return;
            }
            if (!Double.isNaN(fractionPower)) {
                state.power = fractionPower;
                LOG.log(Level.INFO, "The command would have been: pfControl.setHeaterPower(" + heaterId + ", " + fractionPower);
                this.pfControl.setHeaterPower(heaterId, fractionPower);
            }
        }
    }

    protected void maintainPower() {
        for (int chan : this.states.keySet()) {
            this.setPower(chan, Double.NaN);
        }
    }

    public double getPower(int chan) {
        return this.getChannelState((int)chan).power;
    }

    public boolean isEnabled(int chan) {
        return this.getChannelState((int)chan).enabled;
    }

    public boolean hasCurrError(int chan) {
        return this.getChannelState((int)chan).currError;
    }

    public boolean hasNoLoad(int chan) {
        return this.getChannelState((int)chan).noLoad;
    }

    private ChannelState getChannelState(int chan) {
        return this.states.get(chan);
    }

    private void logError(String msg, int chan, DriverException e) {
        LOG.log(Level.SEVERE, "{0} {1} channel {2}{3}", new Object[]{msg, this.name, chan, e == null ? "" : ": " + e});
    }

    static {
        mTypeMap.put("POWER", 0);
        mTypeMap.put("CURRENT", 2);
        LOG = Logger.getLogger(PathfinderPowerDevice.class.getName());
    }

    public static class ChannelState {
        private double power;
        private boolean enabled;
        private boolean currError;
        private boolean noLoad;
    }
}

