/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.jcs3.auxiliary.lateral.LateralElementDescriptor;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class LateralTCPSender {
    private static final Log log = LogManager.getLog(LateralTCPSender.class);
    private final int socketOpenTimeOut;
    private final int socketSoTimeOut;
    private ObjectOutputStream oos;
    private Socket socket;
    private int sendCnt = 0;
    private final Object getLock = new int[0];

    public LateralTCPSender(ITCPLateralCacheAttributes lca) throws IOException {
        this.socketOpenTimeOut = lca.getOpenTimeOut();
        this.socketSoTimeOut = lca.getSocketTimeOut();
        String p1 = lca.getTcpServer();
        if (p1 == null) {
            throw new IOException("Invalid server (null)");
        }
        String h2 = p1.substring(0, p1.indexOf(":"));
        int po = Integer.parseInt(p1.substring(p1.indexOf(":") + 1));
        log.debug("h2 = {0}, po = {1}", h2, po);
        if (h2.length() == 0) {
            throw new IOException("Cannot connect to invalid address [" + h2 + ":" + po + "]");
        }
        this.init(h2, po);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(String host, int port) throws IOException {
        try {
            log.info("Attempting connection to [{0}]", host);
            try {
                this.socket = new Socket();
                this.socket.connect(new InetSocketAddress(host, port), this.socketOpenTimeOut);
            }
            catch (IOException ioe) {
                if (this.socket != null) {
                    this.socket.close();
                }
                throw new IOException("Cannot connect to " + host + ":" + port, ioe);
            }
            this.socket.setSoTimeout(this.socketSoTimeOut);
            LateralTCPSender ioe = this;
            synchronized (ioe) {
                this.oos = new ObjectOutputStream(this.socket.getOutputStream());
            }
        }
        catch (ConnectException e) {
            log.debug("Remote host [{0}] refused connection.", host);
            throw e;
        }
        catch (IOException e) {
            log.debug("Could not connect to [{0}]", host, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void send(LateralElementDescriptor<K, V> led) throws IOException {
        ++this.sendCnt;
        if (log.isInfoEnabled() && this.sendCnt % 100 == 0) {
            log.info("Send Count (port {0}) = {1}", this.socket.getPort(), this.sendCnt);
        }
        log.debug("sending LateralElementDescriptor");
        if (led == null) {
            return;
        }
        if (this.oos == null) {
            throw new IOException("No remote connection is available for LateralTCPSender.");
        }
        Object object = this.getLock;
        synchronized (object) {
            this.oos.writeUnshared(led);
            this.oos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Object sendAndReceive(LateralElementDescriptor<K, V> led) throws IOException {
        if (led == null) {
            return null;
        }
        if (this.oos == null) {
            throw new IOException("No remote connection is available for LateralTCPSender.");
        }
        Object response = null;
        Object object = this.getLock;
        synchronized (object) {
            try {
                if (this.socket.getInputStream().available() > 0) {
                    this.socket.getInputStream().read(new byte[this.socket.getInputStream().available()]);
                }
            }
            catch (IOException ioe) {
                log.error("Problem cleaning socket before send {0}", this.socket, ioe);
                throw ioe;
            }
            this.oos.writeUnshared(led);
            this.oos.flush();
            try (ObjectInputStreamClassLoaderAware ois = new ObjectInputStreamClassLoaderAware(this.socket.getInputStream(), null);){
                this.socket.setSoTimeout(this.socketSoTimeOut);
                response = ois.readObject();
            }
            catch (IOException ioe) {
                String message = "Could not open ObjectInputStream to " + this.socket + " SoTimeout [" + this.socket.getSoTimeout() + "] Connected [" + this.socket.isConnected() + "]";
                log.error(message, ioe);
                throw ioe;
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        return response;
    }

    public void dispose() throws IOException {
        log.info("Dispose called");
        this.oos.close();
        this.socket.close();
    }
}

