package org.lsst.ccs.subsystem.pathfinder;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.pathfinder.data.VacSysState;

/**
 *  Definitions of the pathfinder system switch names.
 *
 *  @author The CCS team
 */
public class SwitchNames {

    public static final String
        HX_TURBO       = "HxTurbo",
        HX_ION_PUMP1   = "HxIon1",
        HX_ION_PUMP2   = "HxIon2",
        HX_VALVE       = "HxValve",
        OR_ION_PUMP    = "OrIon",
        OR_FPP_VALVE   = "OrFppValve",
        OR_FH_VALVE    = "OrFhValve",
        OR_L3H_VALVE   = "OrL3hValve",
        OR_L3_VALVE    = "OrL3Valve";
    //        HX_VALVE_CLOSE = "HxValveClose";
    
    public static final Map<String, Integer> NAME_MAP = new HashMap<>();
    static {
        NAME_MAP.put(HX_TURBO, VacSysState.SW_HX_TURBO);
        NAME_MAP.put(HX_ION_PUMP1, VacSysState.SW_HX_ION_PUMP1);
        NAME_MAP.put(HX_VALVE, VacSysState.SW_HX_VALVE);
	//        NAME_MAP.put(HX_VALVE_CLOSE, VacSysState.SW_HX_VALVE_CLOSE);
	//        NAME_MAP.put(KOOLANCE, VacSysState.SW_KOOLANCE);
	//        NAME_MAP.put(CRYOTEL_PWR, VacSysState.SW_CRYOTEL_PWR);
    }

}
