/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20AnalogControl;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.pathfinder.data.VacuumException;

public class Maq20DevicePF
extends Maq20Device {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Maq20AnalogControl maqCtrl;
    private static final Logger LOG = Logger.getLogger(Maq20DevicePF.class.getName());
    private static final int NUM_HEATERS = 2;
    private static final int WATER_VALVE_CHANNEL = 1;
    private int ctrlModIndex;
    private int currModIndex = -1;
    private long[] setTime = new long[2];
    public static final int CHAN_COLD_HEATER_SET = 0;
    public static final int CHAN_CRYO_HEATER_SET = 2;
    public static final int CHAN_OTHER1_HEATER_SET = 1;
    public static final int CHAN_OTHER2_HEATER_SET = 3;
    public static final int CHAN_OTHER3_HEATER_SET = 4;
    public static final int CHAN_OTHER4_HEATER_SET = 5;
    public static final int CHAN_COLD_HEATER_READ = 11;
    public static final int CHAN_CRYO_HEATER_READ = 12;
    private static final int[] heaterSetChans = new int[2];
    private static final double[] heaterMaxLim;
    private final int minChan = 0;
    private final int maxChan = 1;
    private final Map<Integer, ChannelState> states = new HashMap<Integer, ChannelState>();

    public void initDevice() {
        super.initDevice();
        if (this.maqCtrl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"analog control", (String)"not defined");
        }
        this.ctrlModIndex = this.maqCtrl.getModIndex();
        for (int ix = 0; ix < this.getModuleCount(); ++ix) {
            Maq20Device.ModuleData modData = this.getModuleData(ix);
            if (modData.modDef.type != Maq20.ModuleType.IS) continue;
            this.currModIndex = ix;
            break;
        }
        for (int chan = 0; chan <= 1; ++chan) {
            this.states.put(chan, new ChannelState());
        }
        for (int chan : this.states.keySet()) {
            ChannelState state = this.states.get(chan);
            state.enabled = true;
            state.currError = false;
        }
    }

    public void enableOutput(int chan, boolean enable) {
        ChannelState state = this.getChannelState(chan);
        state.enabled = enable;
        if (!enable) {
            this.setHeaterPower(chan, 0.0);
            state.currError = false;
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        int index = type & 0xFF;
        return value;
    }

    public void setHeaterPower(int heaterId, double fractionPower) {
        if (fractionPower < 0.0 || fractionPower > 1.0) {
            LOG.log(Level.SEVERE, "Disallowed heater power fraction requested " + heaterId + " (heater# " + heaterId + ") fractionPower: " + fractionPower);
        } else {
            try {
                this.setHeaterLevel(heaterId, 4.0 + fractionPower * (heaterMaxLim[heaterId] - 4.0));
            }
            catch (VacuumException e) {
                this.logError("Error setting power output for", heaterId, e);
            }
        }
    }

    public double getHeaterPower(int heaterId) throws VacuumException {
        return 1000.0 * (Math.max(this.getHeaterLevel(heaterId), 0.004) - 0.004) / (heaterMaxLim[heaterId] - 4.0);
    }

    public double setHeaterLevel(int heaterId, double level) throws VacuumException {
        int chan = heaterSetChans[heaterId];
        double value = Math.min(Math.max(level /= 1000.0, 0.0), heaterMaxLim[heaterId] / 1000.0);
        LOG.info("For heaterId " + heaterId + "(chan = " + chan + ") the value being sent is " + value + " input level = " + level);
        try {
            this.maqCtrl.writeValue(chan, value);
            this.setTime[heaterId] = System.currentTimeMillis();
        }
        catch (DriverException e) {
            throw new VacuumException("Error setting heater " + heaterId + " (channel " + chan + ") level: " + (Object)((Object)e));
        }
        return value;
    }

    public void setWaterValveOpen(boolean openValve) throws VacuumException {
        try {
            double curr = openValve ? 0.004 : 0.02;
            LOG.info("Setting maq20 chan 1 to I = " + curr);
            this.maqCtrl.writeValue(1, curr);
        }
        catch (DriverException e) {
            throw new VacuumException("Error actuating water valve: " + (Object)((Object)e));
        }
    }

    public double getWaterValveControlCurrent() throws VacuumException {
        try {
            double level = this.maqCtrl.readValue(1);
            return level;
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    public double getHeaterLevel(int heaterId) throws VacuumException {
        int chan = heaterSetChans[heaterId];
        try {
            double level = this.maqCtrl.readValue(chan);
            return level;
        }
        catch (DriverException e) {
            throw new VacuumException("Error getting heater " + heaterId + " (channel " + chan + ") level: " + (Object)((Object)e));
        }
    }

    public long getHeaterSetTime(int heaterId) {
        return this.setTime[heaterId];
    }

    private ChannelState getChannelState(int chan) {
        return this.states.get(chan);
    }

    private void logError(String msg, int chan, VacuumException e) {
        LOG.log(Level.SEVERE, "{0} {1} channel {2}{3}", new Object[]{msg, this.name, chan, e == null ? "" : ": " + (Object)((Object)e)});
    }

    static {
        Maq20DevicePF.heaterSetChans[0] = 0;
        Maq20DevicePF.heaterSetChans[1] = 2;
        heaterMaxLim = new double[2];
        Maq20DevicePF.heaterMaxLim[0] = 20.0;
        Maq20DevicePF.heaterMaxLim[1] = 9.333333333333332;
    }

    public static class ChannelState {
        private boolean enabled;
        private boolean currError;
    }
}

