package org.lsst.ccs.subsystem.pathfinder;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;
import org.lsst.ccs.subsystem.pathfinder.data.VacuumException;

/**
 * A derived channel to calculate the max of a set of channels
 * 
 * @author The LSST CCS Team
 */
public class MaxChannel extends DerivedChannel
{
    
    private Channel[] channels;  // From Groovy file

    private final Map<String, Integer> nameMap = new LinkedHashMap<>();

    @Override
    public void init()
    {        
        if (channels == null) {
            throw new RuntimeException(getPath() + " parameter error: channels array has not been defined");
        }
        for (int ix = 0; ix < channels.length; ix++) {
            nameMap.put(channels[ix].getPath(), ix);
        }
        super.init();
    }

    @Override
    public double evaluateDerivedValue()
    {
        double valueMax = Double.NaN ;
        for (int ix = 0; ix < channels.length; ix++) {
            double value = channels[ix].getValue();
            if (!Double.isNaN(value)) {
		if (!Double.isNaN(valueMax)) {
		    valueMax = value>valueMax ? value : valueMax;
		} else {
		    valueMax = value;
		}
            }
        }
        return valueMax;
    }

    
}
