/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;

public final class Alert
implements Serializable {
    private static final long serialVersionUID = -568951332963342L;
    private final String alertId;
    private final String description;
    private final Map<String, Object> innerData = new HashMap<String, Object>();

    public Alert(String alertId, String description) {
        this(alertId, description, null);
    }

    @Deprecated
    public Alert(String alertId, String description, Map<String, Object> innerData) {
        if (innerData == null) {
            innerData = Collections.EMPTY_MAP;
        }
        this.alertId = alertId;
        this.description = description;
        for (Map.Entry e : innerData.entrySet()) {
            String key = (String)e.getKey();
            Object obj = e.getValue();
            if (obj instanceof Serializable) {
                this.addAlertData(key, (Serializable)obj);
                continue;
            }
            this.innerData.put(key, obj);
        }
    }

    public String getAlertId() {
        return this.alertId;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getAlertData(String key) {
        Object o = this.innerData.get(key);
        if (o == null || !(o instanceof byte[])) {
            return o;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream((byte[])o);
        try {
            ObjectInputStream ois = new ObjectInputStream(bis);
            return ois.readObject();
        }
        catch (ClassNotFoundException x) {
            throw new EmbeddedObjectDeserializationException("Class not found while deserializing payload " + key, x);
        }
        catch (IOException x) {
            throw new EmbeddedObjectDeserializationException("Could not deserialize payload " + key, x);
        }
    }

    public void addAlertData(String key, Serializable payload) {
        if (this.innerData.containsKey(key)) {
            throw new IllegalArgumentException("Alert " + this.getAlertId() + " already has a payload for key " + key);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(payload);
            this.innerData.put(key, bos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not add data to Alert", ioe);
        }
    }

    public Set<String> getAlertDataNames() {
        return this.innerData.keySet();
    }

    public String toString() {
        return "Alert " + this.getAlertId() + " (" + this.getDescription() + ")";
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Objects.hashCode(this.alertId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alert)) {
            return false;
        }
        Alert other = (Alert)obj;
        return Objects.equals(this.alertId, other.alertId);
    }
}

