/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.twistorr.TwisTorr84;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.common.devices.refrigeration.AVCCryoDevice;
import org.lsst.ccs.subsystem.common.devices.turbopump.TwisTorr84Device;
import org.lsst.ccs.subsystem.pathfinder.CryoTurboDevice;
import org.lsst.ccs.subsystem.pathfinder.FanPIControl;
import org.lsst.ccs.subsystem.pathfinder.IonPumpDevice;
import org.lsst.ccs.subsystem.pathfinder.Maq20DevicePF;
import org.lsst.ccs.subsystem.pathfinder.SwitchNames;
import org.lsst.ccs.subsystem.pathfinder.VacPlutoDevice;
import org.lsst.ccs.subsystem.pathfinder.alerts.PathfinderAlerts;
import org.lsst.ccs.subsystem.pathfinder.constants.ConditionState;
import org.lsst.ccs.subsystem.pathfinder.constants.DeviceState;
import org.lsst.ccs.subsystem.pathfinder.constants.FanState;
import org.lsst.ccs.subsystem.pathfinder.constants.LatchState;
import org.lsst.ccs.subsystem.pathfinder.constants.PLCState;
import org.lsst.ccs.subsystem.pathfinder.constants.SwitchEnable;
import org.lsst.ccs.subsystem.pathfinder.constants.SwitchState;
import org.lsst.ccs.subsystem.pathfinder.constants.UtilTrunkFans;
import org.lsst.ccs.subsystem.pathfinder.constants.VacuumState;
import org.lsst.ccs.subsystem.pathfinder.data.PathfinderAgentProperties;
import org.lsst.ccs.subsystem.pathfinder.data.VacSysState;
import org.lsst.ccs.subsystem.pathfinder.data.VacuumException;

public class PathfinderSubsystem
extends Subsystem
implements HasLifecycle,
AlertListener {
    private static final double PRESS_ATMOS = 759.0;
    private static final double PRESS_TURBO_LOW = 5.0;
    private static final double PRESS_FORELINE_LOW = 5.0;
    private static final double PRESS_DIFF_LOW = 0.09;
    private static final double PRESS_DIFF_HIGH = 20.0;
    private static final double PRESS_ION_OFF = 1.0E-5;
    private static final double PRESS_ION_ENABLE = 4.0E-6;
    private static final double PRESS_VACUUM = 1.0E-7;
    private static final double COMCAM_PRESS_HIGH = 20.0;
    private static final double TURBO_MAX = 81000.0;
    private static final double TURBO_LOW = 8100.0;
    private static final double TURBO_HIGH = 40500.0;
    private static final int MAX_PRESS_ERRORS = 2;
    private static final int MAX_SPEED_ERRORS = 0;
    private static final int DELAY_ION_OFF = 20000;
    private static final int[] switchChannels = new int[5];
    private final FanPIControl[] fanControl = new FanPIControl[1];
    private MonitorTaskControl monitorControl;
    private static final Map<TwisTorr84.PumpStatus, DeviceState> turboStateMap;
    private static final Map<Integer, PathfinderAlerts> alertMap;
    private static final Map<String, Integer> revAlertMap;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService apts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService ass;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private VacPlutoDevice plutoDevc = null;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private CryoTurboDevice cryoTurboDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private IonPumpDevice ionPumpDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    Map<String, AVCCryoDevice> avcMap = new HashMap<String, AVCCryoDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Maq20DevicePF pfControl;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, Channel> channelMap = new LinkedHashMap<String, Channel>();
    private FanPIControl utFan;
    private Channel utFanSpeed;
    private final Channel[] fanSpeedChans = new Channel[1];
    private String pressChan1;
    private String turboSpeedChan;
    private String forelinePressChan;
    private String turboPressChan;
    private String CryoTempChan;
    private String Cold1TempChan;
    private String Cold2TempChan;
    private String IonPumpVoltageChan;
    private List<Integer> switches;
    private static final Logger LOG;
    private final VacSysState vacState = new VacSysState();
    private Set<Integer> switchSet;
    private final Device[] switchDevices = new Device[5];
    private Channel turboPressure;
    private Channel HXPressure;
    private Channel turboSpeed;
    private Channel forelinePressure;
    private Channel CryoTemp;
    private Channel Cold1Temp;
    private Channel Cold2Temp;
    private boolean running = true;
    private final Map<String, Integer> switchNameMap = new LinkedHashMap<String, Integer>();
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();
    private long ionOverStartTime = 0L;
    private boolean plcActive = true;
    private volatile boolean alertResponseEnabled = true;
    private boolean monAlertEnabledVATShut = false;
    private String last_alertStr;
    private boolean useInfoAlerts = System.getProperty("org.lsst.ccs.subsystem.pathfinderPowerInfoAlerts", "false").contains("true");
    private SensorData pfMainPr;
    private SensorData turboMainPr;
    private SensorData forelineMainPr;

    public PathfinderSubsystem() {
        super("pathfinder", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void init() {
        this.alertService.registerAlert(PathfinderAlerts.VACUUM_PLC_NOT_ALIVE.getAlert());
        for (int cond = 0; cond < 8; ++cond) {
            PathfinderAlerts alert = alertMap.get(cond);
            if (alert == null) continue;
            this.alertService.registerAlert(alert.getAlert());
        }
    }

    public void postInit() {
        this.alertService.addListener((AlertListener)this);
        this.agentPropertiesService.setAgentProperty(PathfinderAgentProperties.PATHFINDER_TYPE_AGENT_PROPERTY, PathfinderSubsystem.class.getCanonicalName());
        if (this.switches != null) {
            this.switchSet = new HashSet<Integer>(this.switches);
        } else {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Switch list", (String)"not specified");
        }
        if (this.utFan == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"utFan", (String)"has not been specified");
        }
        this.fanControl[0] = this.utFan;
        if (this.utFanSpeed == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"utFanSpeed", (String)"has not been specified");
        }
        this.fanSpeedChans[0] = this.utFanSpeed;
        if (this.plutoDevc != null) {
            for (int cond : this.plutoDevc.getLatchIds()) {
                this.vacState.addLatch(cond);
                this.vacState.setLatch(cond, LatchState.CLEAR);
                LOG.info("Cleared latch cond  " + cond);
            }
            for (int cond : this.plutoDevc.getConditionIds()) {
                this.vacState.addCondition(cond);
                this.vacState.setCondition(cond, ConditionState.NO);
            }
        } else {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Pluto device", (String)"not specified");
        }
        if (this.cryoTurboDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"PF turbo pump device", (String)"not specified");
        }
        if (this.ionPumpDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Ion pump device", (String)"not specified");
        }
        if (this.forelinePressChan != null) {
            this.forelinePressure = this.channelMap.get(this.forelinePressChan);
        }
        this.forelineMainPr = new SensorData(this.forelinePressure, 2);
        if (this.turboPressChan != null) {
            this.turboPressure = this.channelMap.get(this.turboPressChan);
        }
        if (this.turboPressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Turbo pressure channel", (String)"not specified or not defined");
        }
        this.turboMainPr = new SensorData(this.turboPressure, 2);
        if (this.pressChan1 != null) {
            this.HXPressure = this.channelMap.get(this.pressChan1);
        }
        if (this.HXPressure == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"PF pressure channel", (String)"not specified or not defined");
        }
        this.pfMainPr = new SensorData(this.HXPressure, 2);
        if (this.turboSpeedChan != null) {
            this.turboSpeed = this.channelMap.get(this.turboSpeedChan);
        }
        if (this.turboSpeed == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Turbo pump speed channel", (String)"not specified or not defined");
        }
        if (this.pfControl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Maq20DevicePF component", (String)"has not been defined");
        }
        List<Integer> ipChannels = this.ionPumpDevc.getChannelNumbers();
        LOG.info("ipChannel Names = " + this.ionPumpDevc.getChannelNames());
        LOG.info("ipChannel Numbers = " + this.ionPumpDevc.getChannelNumbers());
        Iterator<Integer> swIter = this.switchSet.iterator();
        while (swIter.hasNext()) {
            int sw = swIter.next();
            switch (sw) {
                case 1: {
                    this.switchDevices[sw] = this.cryoTurboDevc;
                    break;
                }
                case 3: {
                    this.switchDevices[sw] = this.plutoDevc;
                    break;
                }
                case 2: {
                    this.switchDevices[sw] = this.ionPumpDevc;
                    if (ipChannels.contains(switchChannels[sw])) break;
                    swIter.remove();
                }
            }
        }
        Iterator<Object> iterator = this.switchSet.iterator();
        while (iterator.hasNext()) {
            int sw = iterator.next();
            this.vacState.addSwitch(sw);
            this.vacState.setSwitchState(sw, SwitchState.OFFLINE);
            this.vacState.setSwitchEnable(sw, SwitchEnable.OFF);
        }
        for (String swName : SwitchNames.NAME_MAP.keySet()) {
            int sw = SwitchNames.NAME_MAP.get(swName);
            if (!this.switchSet.contains(sw)) continue;
            this.switchNameMap.put(swName, sw);
        }
        LOG.info("Configured the status aggregator to listen to subsystems: " + System.getProperty("org.lsst.ccs.subsystem.teststand", "ts") + " " + System.getProperty("org.lsst.ccs.subsystem.rebps", "ccs-rebps") + " " + System.getProperty("org.lsst.ccs.subsystem.pathfinder", "pathfinder"));
    }

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("vacuum-state", () -> this.updateVacuumState()).withPeriod(Duration.ofMillis(1000L));
        this.apts.scheduleAgentPeriodicTask(pt);
        this.ass.registerState(VacuumState.class, "ComCam Vacuum state", (Object)this);
        this.ass.updateAgentState(new Enum[]{VacuumState.UNKNOWN});
        for (PathfinderAlerts alert : PathfinderAlerts.values()) {
            this.activeAlertMap.put(alert.getId(), false);
        }
    }

    public void postStart() {
        LOG.info("Pathfinder subsystem started");
    }

    public void Sleep(double secs) {
        if (secs <= 0.0) {
            return;
        }
        try {
            Thread.sleep((int)(secs * 1000.0));
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, "Rude awakening!", ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the vacuum system state")
    public VacSysState getVacuumState() {
        this.vacState.setTickMillis(this.getTickPeriod());
        return this.vacState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get switch names")
    public List<String> getSwitchNames() throws VacuumException {
        return new ArrayList<String>(this.switchNameMap.keySet());
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a switch")
    public void setSwitchOn(@Argument(description="The switch number") int sw, @Argument(description="Whether to turn on") boolean on) throws VacuumException {
        try {
            if (!this.switchSet.contains(sw)) {
                throw new VacuumException("Invalid switch number: " + sw);
            }
            this.setSwitch(sw, on);
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setNamedSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws VacuumException {
        Integer sw = this.switchNameMap.get(name);
        try {
            if (sw == null) {
                throw new VacuumException("Invalid switch name: " + name);
            }
            this.setSwitch(sw, on);
        }
        finally {
            this.publishState();
        }
    }

    private void setSwitch(int sw, boolean on) throws VacuumException {
        SwitchState state = this.vacState.getSwitchState(sw);
        LOG.info("setSwitch called for sw = " + sw);
        if (state == SwitchState.OFFLINE) {
            LOG.info("Switch sw = " + sw + " is offline");
        }
        SwitchEnable enable = this.vacState.getSwitchEnable(sw);
        if (on && enable != SwitchEnable.ON && enable != SwitchEnable.WAS_ON) {
            LOG.info("enable = " + enable + " SwitchEnable.ON = " + SwitchEnable.ON + " SwitchEnable.WAS_ON = " + SwitchEnable.WAS_ON);
            return;
        }
        LOG.info("proceeding with setting switch sw = " + sw);
        Device swDevice = this.switchDevices[sw];
        try {
            if (swDevice instanceof TwisTorr84Device) {
                if (on) {
                    ((TwisTorr84Device)swDevice).startTurboPump();
                } else {
                    ((TwisTorr84Device)swDevice).stopTurboPump();
                }
            } else if (swDevice == this.ionPumpDevc) {
                this.ionPumpDevc.setChannelOn(switchChannels[sw], on);
            } else if (swDevice == this.plutoDevc) {
                LOG.info("sending request to PLC(plutoDevc) to set sw=" + sw + " to " + on);
                this.plutoDevc.setSwitchOn(switchChannels[sw], on);
            } else {
                LOG.info("swDevice not identified for sw=" + sw);
            }
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    private Boolean isSwitchOn(int sw) {
        Boolean value = false;
        Device swDevice = this.switchDevices[sw];
        if (swDevice instanceof TwisTorr84Device) {
            try {
                DeviceState st = turboStateMap.get(((TwisTorr84Device)swDevice).readTurboStatus());
                value = st != DeviceState.STOPPED && st != DeviceState.BRAKING;
            }
            catch (DriverException e) {
                value = null;
            }
        } else if (swDevice == this.plutoDevc) {
            if (this.plutoDevc != null) {
                value = this.plutoDevc.isSwitchOn(switchChannels[sw]);
            }
        } else if (swDevice == this.ionPumpDevc) {
            value = this.ionPumpDevc.isChannelOn(switchChannels[sw]);
        }
        return value;
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a condition")
    public void clearLatch(@Argument(description="The condition number") int cond) throws VacuumException {
        try {
            this.plutoDevc.clearLatch(cond);
        }
        finally {
            this.publishState();
        }
    }

    private void readSensor(SensorData data) {
        data.value = data.channel.getValue();
        if (!Double.isNaN(data.value)) {
            data.goodValue = data.value;
            data.numErrors = 0;
        } else if (data.numErrors++ < data.maxErrors) {
            data.value = data.goodValue;
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        this.vacState.setTickMillis(this.getTickPeriod());
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the heater level")
    public String setHeater(@Argument(description="heater ID") int heaterId, @Argument(description="heater level in mA (4-20)") double level) throws VacuumException {
        return "Heater level set to " + this.pfControl.setHeaterLevel(heaterId, level);
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the water valve open or close")
    public void setWaterValveOpen(@Argument(description="true(open)/false(close)") boolean openValve) throws VacuumException {
        this.pfControl.setWaterValveOpen(openValve);
    }

    @Command(type=Command.CommandType.ACTION, description="Gets the heater level")
    public double getHeaterLevel(@Argument(description="heater ID") int heaterId) throws VacuumException {
        return this.pfControl.getHeaterLevel(heaterId);
    }

    @Command(type=Command.CommandType.ACTION, description="Gets the VTC control current")
    public double getWaterValveControlCurrent() throws VacuumException {
        return this.pfControl.getWaterValveControlCurrent();
    }

    private void updateVacuumState() {
        Boolean active;
        int cond;
        SwitchState oldState;
        LOG.info("updateVacuumState called, running = " + this.running);
        if (!this.running) {
            return;
        }
        for (int fan = 0; fan < 1; ++fan) {
            FanState oldState2;
            FanState state = oldState2 = this.vacState.getFanState(fan);
            if (oldState2 == FanState.OFFLINE) {
                Double speed = this.fanControl[fan].getSpeed();
                this.vacState.setFanSpeed(fan, speed == null ? 0.0 : Math.rint(1000.0 * speed) / 1000.0);
                state = speed == null ? FanState.OFFLINE : (speed > 0.0 ? FanState.SPEED : FanState.OFF);
                this.vacState.setFanBaseState(fan, state);
            }
            if (state == oldState2) continue;
            this.vacState.setFanState(fan, state);
        }
        Boolean plcActive = this.plutoDevc.isPLCActive();
        if (plcActive == null) {
            if (this.vacState.getPlcState() != PLCState.OFFLINE) {
                this.raiseAlert(PathfinderAlerts.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC is offline");
                this.vacState.setPlcState(PLCState.OFFLINE);
            }
        } else if (!plcActive.booleanValue()) {
            if (this.vacState.getPlcState() != PLCState.DEAD) {
                this.raiseAlert(PathfinderAlerts.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC has died");
                this.vacState.setPlcState(PLCState.DEAD);
            }
        } else if (this.vacState.getPlcState() != PLCState.ALIVE) {
            this.lowerAlert(PathfinderAlerts.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC is alive");
            this.vacState.setPlcState(PLCState.ALIVE);
        }
        this.readSensor(this.forelineMainPr);
        double forelinePr = this.forelineMainPr.value;
        LOG.info("forelinePressure = " + forelinePr);
        this.readSensor(this.turboMainPr);
        double turboPr = this.turboMainPr.value;
        LOG.info("turboPr = " + turboPr);
        this.readSensor(this.pfMainPr);
        double pfPr = this.pfMainPr.value;
        LOG.info("current pfPr = " + pfPr);
        double turboSp = this.turboSpeed.readValue();
        boolean changed = false;
        boolean forcedVATclosing = false;
        for (int sw = 0; sw < 5; ++sw) {
            SwitchEnable enabled;
            Boolean isOn;
            if (!this.vacState.hasSwitch(sw)) continue;
            Boolean enable = false;
            boolean turnOff = false;
            DeviceState devState = null;
            switch (sw) {
                case 3: {
                    enable = true;
                    boolean enable2 = false;
                    boolean enable_set = false;
                    if (!Double.isNaN(forelinePr)) {
                        enable2 |= forelinePr < 5.0;
                        enable_set = true;
                    }
                    if (!Double.isNaN(turboSp)) {
                        enable2 |= turboSp < 8100.0;
                        enable_set = true;
                    }
                    enable = enable & enable2;
                    if (enable_set) {
                        boolean bl = turnOff = !enable2;
                    }
                    if (!Double.isNaN(pfPr)) {
                        boolean enable3 = pfPr > 20.0 || turboSp > 40500.0;
                        enable = enable & enable3;
                    }
                    forcedVATclosing = turnOff;
                    break;
                }
                case 1: {
                    LOG.fine("pfPr = " + pfPr + " forelinePr = " + forelinePr + " turboSp = " + turboSp);
                    if (!Double.isNaN(forelinePr) && !Double.isNaN(turboSp)) {
                        enable = forelinePr < 5.0 || turboSp < 8100.0;
                        LOG.fine("turbo enable = " + enable + " pfPr = " + pfPr + " PRESS_TURBO_LOW =" + 5.0);
                    }
                    if (!Double.isNaN(forelinePr)) {
                        turnOff = enable == false;
                    }
                    try {
                        devState = turboStateMap.get(((CryoTurboDevice)this.switchDevices[sw]).readTurboStatus());
                    }
                    catch (DriverException enable3) {}
                    break;
                }
                case 2: {
                    if (!Double.isNaN(pfPr)) {
                        enable = pfPr < 4.0E-6;
                        if (pfPr >= 1.0E-5) {
                            if (this.ionOverStartTime == 0L) {
                                this.ionOverStartTime = System.currentTimeMillis();
                                break;
                            }
                            turnOff = System.currentTimeMillis() - this.ionOverStartTime >= 20000L;
                            break;
                        }
                        this.ionOverStartTime = 0L;
                        break;
                    }
                    turnOff = true;
                    break;
                }
                default: {
                    LOG.info("no handler for sw = " + sw);
                }
            }
            oldState = this.vacState.getSwitchState(sw);
            if (turnOff && oldState == SwitchState.ON) {
                try {
                    this.setSwitch(sw, false);
                }
                catch (VacuumException e) {
                    LOG.log(Level.SEVERE, "Error setting switch: ", e);
                }
            }
            SwitchState state = (isOn = this.isSwitchOn(sw)) != null ? (isOn.booleanValue() ? SwitchState.ON : SwitchState.OFF) : SwitchState.OFFLINE;
            SwitchEnable switchEnable = enabled = enable != false ? SwitchEnable.ON : SwitchEnable.OFF;
            if (state != oldState || enabled != this.vacState.getSwitchEnable(sw)) {
                LOG.info("Enabling switch sw=" + sw + " enabled = " + enabled);
                this.vacState.setSwitchState(sw, state);
                this.vacState.setSwitchEnable(sw, enabled);
                changed = true;
            }
            if (devState == this.vacState.getDeviceState(sw)) continue;
            this.vacState.setDeviceState(sw, devState);
            changed = true;
        }
        for (cond = 0; cond < 8; ++cond) {
            LatchState state;
            if (!this.vacState.hasLatch(cond)) continue;
            active = this.plutoDevc.isLatchActive(cond);
            Boolean latched = this.plutoDevc.isLatchLatched(cond);
            if (cond == 1 || cond == 2) {
                active = forcedVATclosing;
            }
            if ((state = active == null || latched == null ? LatchState.OFFLINE : (latched != false ? LatchState.LATCHED : (active != false ? LatchState.ACTIVE : LatchState.CLEAR))) == (oldState = this.vacState.getLatch(cond))) continue;
            this.vacState.setLatch(cond, state);
            PathfinderAlerts alert = alertMap.get(cond);
            if (state == LatchState.ACTIVE) {
                this.raiseAlert(alert, "Vacuum PLC error condition set");
            } else if (state != LatchState.OFFLINE && oldState == LatchState.ACTIVE) {
                this.lowerAlert(alert, "Vacuum PLC error condition cleared");
            }
            changed = true;
        }
        for (cond = 0; cond < 14; ++cond) {
            ConditionState state;
            if (!this.vacState.hasCondition(cond)) continue;
            active = this.plutoDevc.isConditionActive(cond);
            ConditionState conditionState = active == null ? ConditionState.OFF : (state = active != false ? ConditionState.YES : ConditionState.NO);
            if (state == this.vacState.getCondition(cond)) continue;
            this.vacState.setCondition(cond, state);
            changed = true;
        }
        VacuumState vState = Double.isNaN(pfPr) ? VacuumState.UNKNOWN : (pfPr <= 1.0E-7 && this.vacState.getSwitchEnable(3) == SwitchEnable.ON ? VacuumState.VACUUM : (this.vacState.getSwitchState(2) == SwitchState.ON && this.vacState.getSwitchEnable(3) == SwitchEnable.ON ? VacuumState.ION_ON : (this.vacState.getSwitchEnable(2) == SwitchEnable.ON && this.vacState.getSwitchEnable(3) == SwitchEnable.ON ? VacuumState.ION_OFF : (this.vacState.getSwitchState(1) == SwitchState.ON && this.vacState.getSwitchEnable(3) == SwitchEnable.ON ? VacuumState.TURBO_ON : (this.vacState.getSwitchEnable(1) == SwitchEnable.ON && this.vacState.getSwitchEnable(3) == SwitchEnable.ON ? VacuumState.TURBO_OFF : (pfPr < 759.0 ? VacuumState.FORELINE : VacuumState.OFF))))));
        if (vState != this.vacState.getVacuumState()) {
            this.vacState.setVacuumState(vState);
            this.ass.updateAgentState(new Enum[]{vState});
            changed = true;
        }
        if (changed) {
            this.publishState();
        }
        if (forcedVATclosing || this.isMonAlertEnabledVATShut()) {
            this.vacState.setSwitchState(3, SwitchState.OFF);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Enable/disable alert response")
    public void enableAlertResponse(boolean enable) {
        this.alertResponseEnabled = enable;
    }

    @Command(type=Command.CommandType.QUERY, description="Get true/false if the alert response is enabled")
    public boolean isAlertResponseEnabled() {
        return this.alertResponseEnabled;
    }

    @Command(type=Command.CommandType.ACTION, description="Enable/disable vacuum monitoring VAT shutting action")
    public void setMonAlertEnabledVATShut(boolean enable) {
        this.monAlertEnabledVATShut = enable;
    }

    @Command(type=Command.CommandType.QUERY, description="Get true/false if the alert response is enabled")
    public boolean isMonAlertEnabledVATShut() {
        return this.monAlertEnabledVATShut;
    }

    private void raiseAlert(PathfinderAlerts alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.ALARM, cond);
        this.activeAlertMap.put(alert.getId(), true);
    }

    private void lowerAlert(PathfinderAlerts alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.NOMINAL, cond);
        this.activeAlertMap.put(alert.getId(), false);
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() == AlertEvent.AlertEventType.ALERT_RAISED && this.isAlertResponseEnabled()) {
            Alert raisedAlert = event.getAlert();
            String alertId = raisedAlert.getAlertId();
            if (alertId.equals(PathfinderAlerts.PRESSURE_TOO_HIGH.getAlert().getAlertId()) && event.getLevel() == AlertState.ALARM) {
                this.setMonAlertEnabledVATShut(true);
                LOG.info("Shutting the vacuum valve!");
            }
            if (alertId.equals(PathfinderAlerts.LOAD_RTD_OVERTEMP.getAlert().getAlertId()) || alertId.equals(PathfinderAlerts.TEMP_MAX_TOO_HIGH.getAlert().getAlertId())) {
                for (int itry = 0; itry < 2; ++itry) {
                    try {
                        this.setHeater(0, 4.0);
                    }
                    catch (VacuumException ve) {
                        LOG.log(Level.SEVERE, "Failed to turn off heater1 -- manual intervention needed{0}try={1}", new Object[]{ve, itry});
                    }
                    try {
                        this.setHeater(1, 4.0);
                        continue;
                    }
                    catch (VacuumException ve) {
                        LOG.log(Level.SEVERE, "Failed to turn off heater2 -- manual intervention needed{0}try={1}", new Object[]{ve, itry});
                    }
                }
                LOG.info("Set SCR heaters to their minimum setting!");
            }
        }
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        for (String id : event.getClearedIds()) {
            Integer cond = revAlertMap.get(id);
            if (cond == null) continue;
            try {
                this.clearLatch(cond);
            }
            catch (VacuumException e) {
                LOG.log(Level.SEVERE, "Error clearing latched PLC condition ({0}): {1}", new Object[]{cond, e});
            }
        }
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("PathFinderState", (Serializable)this.getVacuumState()));
    }

    private void setTickPeriod(long period) {
        this.apts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.apts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Command(type=Command.CommandType.ACTION, description="Set a fan control state")
    public void setFanState(@Argument(description="The fan name") String name, @Argument(description="The control state") FanState state) throws VacuumException {
        int fanId;
        block12: {
            fanId = UtilTrunkFans.getId((String)name);
            if (state == FanState.OFFLINE) throw new VacuumException("Invalid " + name + " state: " + state);
            if (state == FanState.TEMP && !UtilTrunkFans.hasTempState((int)fanId)) {
                throw new VacuumException("Invalid " + name + " state: " + state);
            }
            VacSysState vacSysState = this.vacState;
            // MONITORENTER : vacSysState
            if (state != this.vacState.getFanBaseState(fanId)) break block12;
            // MONITOREXIT : vacSysState
            this.publishState();
            return;
        }
        this.vacState.setFanBaseState(fanId, state);
        if (this.vacState.getFanState(fanId) == FanState.OFFLINE) {
            // MONITOREXIT : vacSysState
            this.publishState();
            return;
        }
        try {
            this.vacState.setFanState(fanId, state);
            FanPIControl ctrlr = this.fanControl[fanId];
            if (state == FanState.TEMP) {
                ctrlr.setTemperature(this.vacState.getDeltaTemp(fanId));
                ctrlr.startLoop(this.vacState.getFanSpeed(fanId));
                return;
            }
            if (UtilTrunkFans.hasTempState((int)fanId)) {
                ctrlr.stopLoop();
            }
            ctrlr.setSpeed(state == FanState.SPEED ? this.vacState.getFanSpeed(fanId) : 0.0);
            // MONITOREXIT : vacSysState
            return;
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a fan speed")
    public void setFanSpeed(@Argument(description="The fan name") String name, @Argument(description="The fan speed") double speed) throws VacuumException {
        LOG.info("SetFanSpeed called with speed = " + speed);
        try {
            int fanId = UtilTrunkFans.getId((String)name);
            LOG.info("SetFanSpeed called with fanId = " + fanId);
            VacSysState vacSysState = this.vacState;
            synchronized (vacSysState) {
                this.vacState.setFanSpeed(fanId, speed);
                LOG.info("SetFanSpeed checking fanState. State = " + this.vacState.getFanState(fanId));
                if (this.vacState.getFanState(fanId) == FanState.SPEED) {
                    LOG.info("SetFanSpeed calling setspeed");
                    this.fanControl[fanId].setSpeed(speed);
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public VacSysState getFullState() {
        this.vacState.setTickMillis(this.monitorControl.getPublishPeriod());
        return this.vacState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of fan names")
    public List<String> getFanNames() {
        return UtilTrunkFans.getNames();
    }

    static {
        PathfinderSubsystem.switchChannels[2] = 0;
        PathfinderSubsystem.switchChannels[4] = 3;
        PathfinderSubsystem.switchChannels[3] = 2;
        turboStateMap = new HashMap<TwisTorr84.PumpStatus, DeviceState>();
        turboStateMap.put(TwisTorr84.PumpStatus.STOP, DeviceState.STOPPED);
        turboStateMap.put(TwisTorr84.PumpStatus.WAIT_INTLK, DeviceState.WAITING);
        turboStateMap.put(TwisTorr84.PumpStatus.STARTING, DeviceState.STARTNG);
        turboStateMap.put(TwisTorr84.PumpStatus.NORMAL, DeviceState.NORMAL);
        turboStateMap.put(TwisTorr84.PumpStatus.BRAKING, DeviceState.BRAKING);
        turboStateMap.put(TwisTorr84.PumpStatus.FAIL, DeviceState.FAILED);
        turboStateMap.put(TwisTorr84.PumpStatus.AUTO_TUNING, DeviceState.AUTOTUN);
        alertMap = new HashMap<Integer, PathfinderAlerts>();
        alertMap.put(4, PathfinderAlerts.HX_VACUUM_BAD);
        alertMap.put(5, PathfinderAlerts.HX_GATE_FORCED_SHUT);
        alertMap.put(6, PathfinderAlerts.HX_GATE_CANNOT_OPEN);
        alertMap.put(7, PathfinderAlerts.HX_TURBO_PUMP_BAD);
        revAlertMap = new HashMap<String, Integer>();
        for (int cond : alertMap.keySet()) {
            revAlertMap.put(alertMap.get(cond).getId(), cond);
        }
        LOG = Logger.getLogger(PathfinderSubsystem.class.getName());
    }

    static class SensorData {
        Channel channel;
        int maxErrors;
        int numErrors = 0;
        double value = 0.0;
        double goodValue = Double.NaN;

        private SensorData(Channel channel, int maxErrors) {
            this.channel = channel;
            this.maxErrors = maxErrors;
        }
    }
}

