/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.pathfinder.PathfinderSubsystem;
import org.lsst.ccs.subsystem.pathfinder.alerts.PathfinderAlerts;
import org.lsst.ccs.subsystem.pathfinder.data.VacuumException;
import org.lsst.ccs.utilities.logging.Logger;

public class PathfinderAlertHandler
implements HasLifecycle,
Monitor.AlarmHandler,
ClearAlertHandler {
    private static final Logger LOG = Logger.getLogger((String)"org.lsst.ccs.subsystem.pathfinder.alarms");
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PathfinderSubsystem pathfinder;

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        LOG.info((Object)("processing alarms .... alert response enable = " + this.pathfinder.isAlertResponseEnabled()));
        if (parm == PathfinderAlerts.PRESSURE_TOO_HIGH.ordinal() && this.pathfinder.isAlertResponseEnabled()) {
            this.alertService.raiseAlert(PathfinderAlerts.PRESSURE_TOO_HIGH.getAlert(), PathfinderAlertHandler.getAlarmStateFromEvent(event), alarmName + ": " + cause);
            switch (event) {
                case 0: {
                    this.pathfinder.setMonAlertEnabledVATShut(true);
                    LOG.info((Object)"Shutting the vacuum valve!");
                    Thread t = new Thread(new VacuumAlarmResponse());
                    t.start();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            return true;
        }
        if (parm == PathfinderAlerts.LOAD_RTD_OVERTEMP.ordinal() && this.pathfinder.isAlertResponseEnabled()) {
            this.alertService.raiseAlert(PathfinderAlerts.LOAD_RTD_OVERTEMP.getAlert(), PathfinderAlertHandler.getAlarmStateFromEvent(event), alarmName + ": " + cause);
            switch (event) {
                case 0: {
                    for (int itry = 0; itry < 2; ++itry) {
                        try {
                            this.pathfinder.setHeater(0, 4.0);
                        }
                        catch (VacuumException ve) {
                            LOG.severe((Object)("Failed to turn off heater1 -- manual intervention needed" + ve + "try=" + itry));
                        }
                        try {
                            this.pathfinder.setHeater(1, 4.0);
                            continue;
                        }
                        catch (VacuumException ve) {
                            LOG.severe((Object)("Failed to turn off heater2 -- manual intervention needed" + ve + "try=" + itry));
                        }
                    }
                    LOG.info((Object)"Set SCR heaters to their minimum setting!");
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private static AlertState getAlarmStateFromEvent(int event) {
        switch (event) {
            case 0: {
                return AlertState.ALARM;
            }
            case 1: {
                return AlertState.WARNING;
            }
            case 2: {
                return AlertState.WARNING;
            }
            case 3: {
                return AlertState.NOMINAL;
            }
        }
        throw new IllegalArgumentException("Unknown event: id " + event);
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
        for (PathfinderAlerts pathfinderAlert : PathfinderAlerts.values()) {
            Alarm a;
            if (!pathfinderAlert.getId().equals(alert.getAlertId()) || (a = this.getAlarmById(pathfinderAlert.ordinal())) == null) continue;
            a.clearState();
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    class VacuumAlarmResponse
    implements Runnable {
        VacuumAlarmResponse() {
        }

        @Override
        public void run() {
        }
    }
}

