/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.pathfinder.HexValve;
import org.lsst.ccs.subsystem.pathfinder.ValveMaq20Device;
import org.lsst.ccs.subsystem.pathfinder.constants.CmprPosnState;
import org.lsst.ccs.subsystem.pathfinder.constants.CmprSetState;
import org.lsst.ccs.subsystem.pathfinder.constants.HexCmprState;
import org.lsst.ccs.subsystem.pathfinder.constants.HexValves;
import org.lsst.ccs.subsystem.pathfinder.constants.ValvePosnState;
import org.lsst.ccs.subsystem.pathfinder.constants.ValveSetState;
import org.lsst.ccs.subsystem.pathfinder.data.HexValveState;
import org.lsst.ccs.subsystem.pathfinder.data.VacuumException;

public class HexValveMain
extends Subsystem
implements HasLifecycle,
ClearAlertHandler,
AlertListener {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    ValveMaq20Device maqDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, HexValve> valveMap = new HashMap<String, HexValve>();
    private static final Logger LOG = Logger.getLogger(HexValveMain.class.getName());
    private static final HexValve[] valveList = new HexValve[18];
    private final HexValveState valveState = new HexValveState();

    public HexValveMain() {
        super("hexvalve", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("valve-state", () -> this.publishUpdatedValveState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("hexValveType", HexValveMain.class.getCanonicalName());
        this.alertService.addListener((AlertListener)this);
        if (this.maqDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"MAQ20 device", (String)"not defined");
        }
        for (String vName : HexValves.valveNameMap.keySet()) {
            if (!this.valveMap.containsKey(vName)) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)("valve " + vName), (String)"not defined");
            }
            HexValveMain.valveList[HexValves.valveNameMap.get((Object)vName).intValue()] = this.valveMap.get(vName);
        }
        for (String vName : this.valveMap.keySet()) {
            if (HexValves.valveNameMap.containsKey(vName)) continue;
            LOG.log(Level.WARNING, "Unrecognized valve name defined: {0} - will be removed", vName);
            this.valveMap.remove(vName);
        }
    }

    public void postStart() {
        LOG.log(Level.INFO, "Heat exchanger valve subsystem started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.QUERY, description="Get the hex valve state", level=0)
    public HexValveState getSystemState() {
        HexValveState hexValveState = this.valveState;
        synchronized (hexValveState) {
            return this.valveState;
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the valid heat exchanger names", level=0)
    public List<String> getHexNames() {
        return new ArrayList<String>(HexValves.hxNameMap.keySet());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the valid compressor names", level=0)
    public List<String> getCmprNames() {
        return new ArrayList<String>(HexValves.cmprNameMap.keySet());
    }

    @Command(type=Command.CommandType.ACTION, description="Connect hex to compressor")
    public void connectHex(@Argument(description="Heat exchanger name") String hex, @Argument(description="Compressor name") String comp) throws VacuumException {
        Integer hexNum = HexValves.hxNameMap.get(hex);
        if (hexNum == null) {
            throw new VacuumException("Invalid heat exchanger name: " + hex);
        }
        Integer cmprNum = HexValves.cmprNameMap.get(comp);
        if (cmprNum == null) {
            throw new VacuumException("Invalid compressor name: " + comp);
        }
        if (!HexValves.hxCmprSets[hexNum].contains(cmprNum)) {
            throw new VacuumException("Heat exchanger " + hex + " cannot be connected to compressor " + comp);
        }
        for (int cNum : HexValves.hxCmprSets[hexNum]) {
            for (int valve : HexValves.cmprValveSets[cNum]) {
                if (cNum == cmprNum) {
                    valveList[valve].setOpen();
                    continue;
                }
                valveList[valve].setShut();
            }
        }
        this.maqDevc.setValves();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setUpdatePeriod(@Argument(description="Tick interval (ms)") int value) {
        HexValveState hexValveState = this.valveState;
        synchronized (hexValveState) {
            this.setTickPeriod(value);
            this.publishState();
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        String id = alert.getAlertId();
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        for (String string : event.getClearedIds()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishUpdatedValveState() {
        HexValveState hexValveState = this.valveState;
        synchronized (hexValveState) {
            Object vpState;
            boolean changed = false;
            this.maqDevc.getSetValves();
            this.maqDevc.readPositions();
            for (int vNum = 0; vNum < 18; ++vNum) {
                HexValve valve = valveList[vNum];
                ValveSetState vsState = valve.getSetState();
                if (vsState != this.valveState.getSetState(vNum)) {
                    this.valveState.setSetState(vNum, vsState);
                    changed = true;
                }
                if ((vpState = valve.getPosnState()) == this.valveState.getPosnState(vNum)) continue;
                this.valveState.setPosnState(vNum, (ValvePosnState)((Object)vpState));
                changed = true;
            }
            if (changed) {
                for (int hNum = 0; hNum < 2; ++hNum) {
                    int csStates = 0;
                    int cpStates = 0;
                    vpState = HexValves.hxCmprSets[hNum].iterator();
                    while (vpState.hasNext()) {
                        CmprSetState cSetState;
                        int cNum = (Integer)vpState.next();
                        int vsStates = 0;
                        int vpStates = 0;
                        for (int vNum : HexValves.cmprValveSets[cNum]) {
                            vsStates |= 1 << this.valveState.getSetState(vNum).ordinal();
                            vpStates |= 1 << this.valveState.getPosnState(vNum).ordinal();
                        }
                        CmprSetState cmprSetState = (vsStates & 1 << ValveSetState.OFFLINE.ordinal()) != 0 ? CmprSetState.OFFLINE : ((vsStates & 1 << ValveSetState.OPEN.ordinal()) != 0 ? ((vsStates & 1 << ValveSetState.SHUT.ordinal()) != 0 ? CmprSetState.MIXED : CmprSetState.OPEN) : (cSetState = CmprSetState.SHUT));
                        CmprPosnState cPosnState = (vpStates & 1 << ValvePosnState.OFFLINE.ordinal()) != 0 ? CmprPosnState.OFFLINE : ((vpStates & 1 << ValvePosnState.BOTH.ordinal()) != 0 ? CmprPosnState.BOTH : ((vpStates & 1 << ValvePosnState.NONE.ordinal()) != 0 ? CmprPosnState.NONE : ((vpStates & 1 << ValvePosnState.OPEN.ordinal()) != 0 ? ((vpStates & 1 << ValvePosnState.SHUT.ordinal()) != 0 ? CmprPosnState.MIXED : CmprPosnState.OPEN) : CmprPosnState.SHUT)));
                        this.valveState.setCmprState(cNum, cSetState);
                        csStates |= 1 << cSetState.ordinal();
                        cpStates |= 1 << cPosnState.ordinal();
                    }
                    HexCmprState hexState = (csStates & 1 << CmprSetState.OFFLINE.ordinal()) != 0 || (cpStates & 1 << CmprPosnState.OFFLINE.ordinal()) != 0 ? HexCmprState.OFFLINE : ((csStates & 1 << CmprSetState.MIXED.ordinal()) != 0 ? HexCmprState.SETERROR : ((cpStates & 1 << CmprPosnState.MIXED.ordinal()) != 0 || (cpStates & 1 << CmprPosnState.BOTH.ordinal()) != 0 || (cpStates & 1 << CmprPosnState.NONE.ordinal()) != 0 ? HexCmprState.POSNERROR : HexCmprState.NORMAL));
                    this.valveState.setHexState(hNum, hexState);
                }
                this.publishState();
            }
        }
    }

    private void publishState() {
        this.valveState.setTickMillis(this.getTickPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("HexValveState", (Serializable)this.valveState));
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }
}

