/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.util.Lookup;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;

public final class MetaInfServicesLookup
extends AbstractLookup {
    private static final boolean DEBUG = Boolean.getBoolean("org.openide.util.MetaInfServicesLookup.DEBUG");
    private static final Map knownInstances = new WeakHashMap();
    private final Set classes = new WeakSet();
    private final ClassLoader loader;
    static /* synthetic */ Class class$org$openide$util$MetaInfServicesLookup;
    static /* synthetic */ Class class$java$lang$Object;

    public MetaInfServicesLookup() {
        this((class$org$openide$util$MetaInfServicesLookup == null ? (class$org$openide$util$MetaInfServicesLookup = MetaInfServicesLookup.class$("org.openide.util.MetaInfServicesLookup")) : class$org$openide$util$MetaInfServicesLookup).getClassLoader());
    }

    public MetaInfServicesLookup(ClassLoader loader) {
        this.loader = loader;
        if (DEBUG) {
            System.err.println("Created: " + this);
        }
    }

    public String toString() {
        return "MetaInfServicesLookup[" + this.loader + "]";
    }

    protected final synchronized void beforeLookup(Lookup.Template t) {
        Class c = t.getType();
        if (this.classes.add(c)) {
            ArrayList arr = new ArrayList();
            this.search(c, arr);
            Iterator it = arr.iterator();
            while (it.hasNext()) {
                AbstractLookup.Pair p = (AbstractLookup.Pair)it.next();
                this.addPair(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(Class clazz, Collection result) {
        Enumeration<URL> en;
        if (DEBUG) {
            System.err.println("Searching for " + clazz.getName() + " in " + clazz.getClassLoader() + " from " + this);
        }
        String res = "META-INF/services/" + clazz.getName();
        try {
            en = this.loader.getResources(res);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        ArrayList foundClasses = new ArrayList();
        ArrayList removeClasses = new ArrayList();
        boolean foundOne = false;
        while (en.hasMoreElements()) {
            if (!foundOne) {
                foundOne = true;
                Class<?> realMcCoy = null;
                try {
                    realMcCoy = this.loader.loadClass(clazz.getName());
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                if (realMcCoy != clazz) {
                    if (DEBUG) {
                        if (realMcCoy != null) {
                            System.err.println(clazz.getName() + " is not the real McCoy! Actually found it in " + realMcCoy.getClassLoader());
                        } else {
                            System.err.println(clazz.getName() + " could not be found in " + this.loader);
                        }
                    }
                    return;
                }
            }
            URL url = en.nextElement();
            try {
                InputStream is = url.openStream();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        Class<?> inst;
                        if ((line = line.trim()).length() == 0) continue;
                        boolean remove = false;
                        if (line.charAt(0) == '#') {
                            if (line.length() == 1 || line.charAt(1) != '-') continue;
                            remove = true;
                            line = line.substring(2);
                        }
                        if (!clazz.isAssignableFrom(inst = Class.forName(line, false, this.loader))) {
                            if (DEBUG) {
                                System.err.println("Not a subclass");
                            }
                            throw new ClassNotFoundException(inst.getName() + " not a subclass of " + clazz.getName());
                        }
                        if (remove) {
                            removeClasses.add(inst);
                            continue;
                        }
                        foundClasses.add(inst);
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (DEBUG) {
            System.err.println("Found impls of " + clazz.getName() + ": " + foundClasses + " and removed: " + removeClasses + " from: " + this);
        }
        foundClasses.removeAll(removeClasses);
        Iterator it = foundClasses.iterator();
        while (it.hasNext()) {
            Class inst = (Class)it.next();
            result.add(new P(inst));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class P
    extends AbstractLookup.Pair {
        private Object object;

        public P(Class clazz) {
            this.object = clazz;
        }

        private Class clazz() {
            Object o = this.object;
            if (o instanceof Class) {
                return (Class)o;
            }
            if (o != null) {
                return o.getClass();
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = MetaInfServicesLookup.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public boolean equals(Object o) {
            if (o instanceof P) {
                return ((P)o).clazz().equals(this.clazz());
            }
            return false;
        }

        public int hashCode() {
            return this.clazz().hashCode();
        }

        protected boolean instanceOf(Class c) {
            return c.isAssignableFrom(this.clazz());
        }

        public Class getType() {
            return this.clazz();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getInstance() {
            Object o = this.object;
            if (o instanceof Class) {
                Object object = o;
                synchronized (object) {
                    try {
                        Class c = (Class)o;
                        Map map = knownInstances;
                        synchronized (map) {
                            o = knownInstances.get(c);
                        }
                        if (o == null) {
                            o = c.newInstance();
                            map = knownInstances;
                            synchronized (map) {
                                knownInstances.put(c, o);
                            }
                        }
                        this.object = o;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.object = null;
                    }
                }
            }
            return this.object;
        }

        public String getDisplayName() {
            return this.clazz().getName();
        }

        public String getId() {
            return this.clazz().getName();
        }

        protected boolean creatorOf(Object obj) {
            return obj == this.object;
        }
    }
}

