/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.gconsole.plugins.tracer.FilterRegistry;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.TracerMessage;

public class TracerFilter
implements MessageFilter {
    public static final String T_P_DELIMETER = "<=>";
    private static final Pattern pPar = Pattern.compile("\\$\\{([^}]+)\\}");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final HashMap<String, Function<FilteredMessage, String>> key2func = new HashMap();
    private String name;
    private Mode mode;
    private boolean invert;
    private boolean format;
    private Target target;
    private Method method;
    private String code;
    private Color color;
    private FilteredMessage.Flag action;
    private Class clazz;
    private Predicate<String> tester;
    private MessageFilter delegate;
    private String pattern;
    private String[] template;

    public TracerFilter(Mode mode, boolean invert, boolean format, Target target, Method method, String code, Color color, FilteredMessage.Flag action, FilterRegistry registry) {
        this.mode = mode;
        this.invert = invert;
        this.format = format;
        this.target = target;
        this.method = method;
        this.action = action;
        this.color = color;
        this.code = code;
        try {
            switch (target) {
                case TEMPLATE: {
                    String[] tokens = code.split(T_P_DELIMETER);
                    String temp = tokens[0];
                    Matcher m = pPar.matcher(temp);
                    ArrayList<String> t = new ArrayList<String>();
                    int s = 0;
                    while (m.find()) {
                        t.add(temp.substring(s, m.start()));
                        t.add(m.group(1));
                        s = m.end();
                    }
                    if (s < temp.length()) {
                        t.add(temp.substring(s));
                    }
                    this.template = t.toArray(new String[t.size()]);
                    this.pattern = tokens.length == 1 ? "" : tokens[1];
                    break;
                }
                default: {
                    this.pattern = code;
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException x) {
            throw new IllegalArgumentException("Unable to create tracer filter", x);
        }
        try {
            switch (method) {
                case REGEX: {
                    this.tester = Pattern.compile(this.pattern).asPredicate();
                    break;
                }
                case WILDCARD: {
                    this.pattern = TracerFilter.wildcardToRegex(this.pattern);
                    this.tester = Pattern.compile(this.pattern).asPredicate();
                    break;
                }
                case CONTAINS: {
                    this.tester = message -> message.contains(this.pattern);
                    break;
                }
                case EQUALS: {
                    this.tester = message -> message.equals(this.pattern);
                    break;
                }
                case CLASS: {
                    this.clazz = Class.forName(this.pattern);
                    break;
                }
                case NAME: {
                    if (registry == null) {
                        throw new IllegalArgumentException("Filter registry is not specified");
                    }
                    this.delegate = registry.createFilter(this.pattern);
                    if (this.delegate == null) {
                        throw new IllegalArgumentException("Unknown filter: " + code);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown filtering method: " + (Object)((Object)method));
                }
            }
        }
        catch (ClassNotFoundException | IllegalArgumentException x) {
            throw new IllegalArgumentException("Unable to create tracer filter", x);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isInverted() {
        return this.invert;
    }

    public boolean isFormatting() {
        return this.format;
    }

    public Target getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getCode() {
        return this.code;
    }

    public Color getColor() {
        return this.color;
    }

    public FilteredMessage.Flag getAction() {
        return this.action;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPath() {
        return this.name;
    }

    @Override
    public FilteredMessage test(FilteredMessage filteredMessage) {
        boolean accept;
        Object targetObject;
        if (this.mode == Mode.OFF) {
            return filteredMessage;
        }
        try {
            switch (this.target) {
                case MESSAGE: {
                    targetObject = filteredMessage.getBusMessage();
                    break;
                }
                case OBJECT: {
                    targetObject = filteredMessage.getBusMessage().getObject();
                    break;
                }
                case SOURCE: {
                    targetObject = filteredMessage.getBusMessage().getOriginAgentInfo().getName();
                    break;
                }
                case TEXT: {
                    targetObject = filteredMessage.getText();
                    if (targetObject == null) {
                        targetObject = filteredMessage.getBusMessage().toString();
                    }
                    break;
                }
                case FLAG: {
                    EnumSet<FilteredMessage.Flag> flags = filteredMessage.getFlags();
                    if (flags == null) {
                        targetObject = "";
                        break;
                    }
                    StringBuilder sb = new StringBuilder();
                    flags.forEach(flag -> sb.append(",").append(flag));
                    targetObject = sb.substring(1);
                    break;
                }
                case TEMPLATE: {
                    targetObject = this.expand(filteredMessage);
                    break;
                }
                default: {
                    targetObject = null;
                    break;
                }
            }
        }
        catch (Throwable t) {
            targetObject = null;
        }
        boolean bl = accept = targetObject != null;
        if (accept) {
            switch (this.method) {
                case REGEX: 
                case WILDCARD: 
                case CONTAINS: 
                case EQUALS: {
                    String s = targetObject.toString();
                    accept = this.tester.test(targetObject.toString());
                    break;
                }
                case CLASS: {
                    accept = this.clazz.isAssignableFrom(targetObject.getClass());
                    break;
                }
                case NAME: {
                    FilteredMessage fm = new TracerMessage(filteredMessage);
                    if (targetObject instanceof String) {
                        fm.setText((String)targetObject);
                    }
                    if ((fm = this.delegate.test(fm)) == null) {
                        accept = false;
                        break;
                    }
                    accept = true;
                    targetObject = fm;
                }
            }
        }
        if (this.invert) {
            boolean bl2 = accept = !accept;
        }
        if (accept) {
            if (this.format) {
                if (targetObject instanceof FilteredMessage) {
                    filteredMessage = (FilteredMessage)targetObject;
                } else if (targetObject != null) {
                    filteredMessage.setMessage(targetObject.toString());
                }
            }
            if (this.color != null) {
                filteredMessage.setColor(this.color);
            }
            if (this.action != null) {
                filteredMessage.addFlag(this.action, new FilteredMessage.Flag[0]);
            }
            return filteredMessage;
        }
        return this.mode == Mode.ON ? null : filteredMessage;
    }

    private String expand(FilteredMessage message) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.template.length) {
            sb.append(this.template[i++]);
            if (i >= this.template.length) continue;
            sb.append(this.expand(this.template[i++], message));
        }
        return sb.toString();
    }

    private String expand(String key, FilteredMessage message) {
        Object o;
        String out = key2func.get(key).apply(message);
        if (out == null && (o = message.getProperty(key)) != null) {
            out = o.toString();
        }
        return out;
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder();
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        return s.toString();
    }

    static {
        key2func.put("SOURCE", m -> m.getBusMessage().getOriginAgentInfo().getName());
        key2func.put("TEXT", m -> m.getMessage());
        key2func.put("DATE", m -> dateFormat.format(new Date(m.getBusMessage().getCCSTimeStamp().getUTCInstant().toEpochMilli())));
        key2func.put("TIME", m -> timeFormat.format(new Date(m.getBusMessage().getCCSTimeStamp().getUTCInstant().toEpochMilli())));
        key2func.put("DT", m -> dtFormat.format(new Date(m.getBusMessage().getCCSTimeStamp().getUTCInstant().toEpochMilli())));
        key2func.put("LOGGER", m -> ((LogMessage)m.getBusMessage()).getLoggerName());
        key2func.put("LEVEL", m -> ((LogMessage)m.getBusMessage()).getLevel());
        key2func.put("MESSAGE", m -> ((LogMessage)m.getBusMessage()).getFormattedDetails());
        key2func.put("STATE", m -> ((StatusMessage)m.getBusMessage()).getState().toString());
        key2func.put("DESTINATION", m -> ((CommandMessage)m.getBusMessage()).getDestination());
    }

    public static enum Method {
        REGEX("The definition string is a regular expression the target should match.", "Reg Ex"),
        WILDCARD("The definition string is a Unix-style wildcard the target should match.", "Wildcard"),
        CONTAINS("The target should contain the definition string.", "Contains"),
        EQUALS("The target should be equal to the definition string.", "Equals"),
        CLASS("The target should be an instance of the class specified by the<br> definition string, or of its subclass.", "Class"),
        NAME("The definition string is the name of the filter that should be<br> applied to the target.", "Name");

        private final String toolTip;
        private final String hr;

        private Method(String toolTip, String humanReadable) {
            this.toolTip = toolTip;
            this.hr = humanReadable;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public String toString() {
            return this.hr;
        }
    }

    public static enum Target {
        MESSAGE("The filter is applied to the bus message object. If the Method of<br> the filter requires a string as a target, the message is<br> converted to a string.", "Message"),
        OBJECT("The filter is applied to the subsystem-provided object embedded<br> into the bus message. If the Method of the filter requires<br> a string as a target, the object is converted to a string.", "Object"),
        SOURCE("The filter is applied to the name of the BusMessage origin.", "Source"),
        TEXT("The filter is applied to the string produced by formatters embedded<br> in previously applied filters. If none of the previously applied<br> filters formatted the message, the BusMessage is converted to<br> String by calling its toString() method.", "Text"),
        FLAG("The filter is applied to the comma-separated list of flags attached<br> to the message.", "Flag"),
        TEMPLATE("The filter definition string is expected to be in <br><tt>Template==Definition</tt> format. The filter is applied to<br> the string produced by parsing the message with the template.<br> If parsing fails, the filter is not satisfied. The template<br> may include place holders in the <tt>${name}</tt> format,<br> where <tt>name</tt> is a name of the message property, or one<br> of the following:<br> <b>SOURCE:</b> Name of message origin<br> <b>TEXT</b> String formatted by previous filters<br> <b>DATE</b> Message date in 'yyyy-MM-dd' format<br> <b>TIME</b> Message time in 'HH:mm:ss' format<br> <b>DT</b> Message date and time in 'yyyy-MM-dd HH:mm:ss' format<br> <b>LOGGER</b> Name of the logger<br> <b>LEVEL</b> Level of the log message<br> <b>MESSAGE</b> Formatted message associated with the bus message<br> <b>STATE</b> Subsystem state embedded in the status message<br> <b>DESTINATION</b> Destination of the command message<br>", "Template");

        private final String toolTip;
        private final String hr;

        private Target(String toolTip, String humanReadable) {
            this.toolTip = toolTip;
            this.hr = humanReadable;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public String toString() {
            return this.hr;
        }
    }

    public static enum Mode {
        ON("Reject messages that do not satisfy this filter", "On"),
        PASS("Accept all messages, change properties of those that satisfy this filter", "Pass"),
        OFF("Ignore this filter", "Off");

        private final String toolTip;
        private final String hr;

        private Mode(String toolTip, String humanReadable) {
            this.toolTip = toolTip;
            this.hr = humanReadable;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public String toString() {
            return this.hr;
        }
    }
}

