/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder.ui.jas;

import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.pathfinder.data.PathfinderAgentProperties;
import org.lsst.ccs.subsystem.pathfinder.data.VacSysState;
import org.lsst.ccs.subsystem.pathfinder.ui.PathfinderControlPanel;
import org.lsst.ccs.subsystem.pathfinder.ui.PathfinderPage;

@Plugin(name="Pathfinder Plugin", description="Pathfinder Plugin")
public class PathfinderControlPlugin
extends ConsolePlugin {
    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new MonOptionalPage(PathfinderAgentProperties.PATHFINDER_TYPE_AGENT_PROPERTY, PathfinderControl.class, "Control", true, new String[0]));
        OptionalPage.getService().add((OptionalPage)new VacImageOptionalPage());
    }

    public static class PathfinderControl
    extends ControlPanel
    implements StatusMessageListener {
        private PathfinderControlPanel ctrlPanel;

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("PathFinderState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        public JPanel getControlPanel(String agent) {
            this.ctrlPanel = new PathfinderControlPanel(agent);
            return this.ctrlPanel;
        }

        public void initControlPanel() {
            this.ctrlPanel.initPanel();
        }

        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updatePanel((VacSysState)obj);
        }

        public void disableControlPanel() {
            this.ctrlPanel.disablePanel();
        }

        public StatusMessageListener getListener() {
            return this;
        }
    }

    static class VacImageOptionalPage
    implements OptionalPage {
        private PathfinderPage pathfinderPage;

        VacImageOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty(PathfinderAgentProperties.PATHFINDER_TYPE_AGENT_PROPERTY) ? "CCS Subsystems/" + agent.getName() + "/Schematic" : null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            this.pathfinderPage = new PathfinderPage(agent);
            JComponent panel = this.pathfinderPage.getView().getPanel();
            panel.setName(agent.getName() + " Schematic");
            return panel;
        }

        public void opened(String page) {
            this.pathfinderPage.getView().install();
        }

        public void closed(String page) {
            this.pathfinderPage.getView().uninstall();
            this.pathfinderPage = null;
        }
    }
}

