/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.ObjectFactoryException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public class ObjectFactory {
    private Class m_c;

    public ObjectFactory(Class c) {
        this.m_c = c;
    }

    public Object create() throws ObjectFactoryException {
        Object[] arg = new Object[]{};
        return this.create(arg);
    }

    public Object create(Object a1) throws ObjectFactoryException {
        Object[] arg = new Object[]{a1};
        return this.create(arg);
    }

    public Object create(Object a1, Object a2) throws ObjectFactoryException {
        Object[] arg = new Object[]{a1, a2};
        return this.create(arg);
    }

    public Object create(Object a1, Object a2, Object a3) throws ObjectFactoryException {
        Object[] arg = new Object[]{a1, a2, a3};
        return this.create(arg);
    }

    public boolean checkAccess() {
        return Modifier.isPublic(this.m_c.getModifiers());
    }

    public boolean inheritsFrom(Class baseClass) {
        return baseClass.isAssignableFrom(this.m_c);
    }

    public Object create(Object a1, Object a2, Object a3, Object a4) throws ObjectFactoryException {
        Object[] arg = new Object[]{a1, a2, a3, a4};
        return this.create(arg);
    }

    public Object create(Object[] args) throws ObjectFactoryException {
        Class[] argc = this.argClass(args);
        try {
            Constructor x = this.findConstructor(argc);
            return x.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            throw new ObjectFactoryException("Error creating object of class " + this.m_c, e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectFactoryException("Error creating object of class " + this.m_c, e);
        }
        catch (InstantiationException e) {
            throw new ObjectFactoryException("Error creating object of class " + this.m_c, e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectFactoryException("Invocation Target Exception for class" + this.m_c, e.getTargetException());
        }
    }

    public boolean canBeCreatedFrom() {
        Class[] argc = new Class[]{};
        return this.canBeCreatedFrom(argc);
    }

    public boolean canBeCreatedFrom(Class c1) {
        Class[] argc = new Class[]{c1};
        return this.canBeCreatedFrom(argc);
    }

    public boolean canBeCreatedFrom(Class c1, Class c2) {
        Class[] argc = new Class[]{c1, c2};
        return this.canBeCreatedFrom(argc);
    }

    public boolean canBeCreatedFrom(Class c1, Class c2, Class c3) {
        Class[] argc = new Class[]{c1, c2, c3};
        return this.canBeCreatedFrom(argc);
    }

    public boolean canBeCreatedFrom(Class c1, Class c2, Class c3, Class c4) {
        Class[] argc = new Class[]{c1, c2, c3, c4};
        return this.canBeCreatedFrom(argc);
    }

    public boolean canBeCreatedFrom(Class[] argc) {
        try {
            this.findConstructor(argc);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private Class[] argClass(Object[] args) {
        Class[] result = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = args[i].getClass();
            if (result[i] == Double.class) {
                result[i] = Double.TYPE;
            }
            if (result[i] == Boolean.class) {
                result[i] = Boolean.TYPE;
            }
            if (result[i] == Integer.class) {
                result[i] = Integer.TYPE;
            }
            if (result[i] == Float.class) {
                result[i] = Float.TYPE;
            }
            if (result[i] == Byte.class) {
                result[i] = Byte.TYPE;
            }
            if (result[i] == Character.class) {
                result[i] = Character.TYPE;
            }
            if (result[i] == Long.class) {
                result[i] = Long.TYPE;
            }
            if (result[i] == Short.class) {
                result[i] = Short.TYPE;
            }
            if (result[i] != Void.class) continue;
            result[i] = Void.TYPE;
        }
        return result;
    }

    private Constructor findConstructor(Class[] argc) throws NoSuchMethodException {
        Constructor<?>[] x = this.m_c.getConstructors();
        block0: for (int i = 0; i < x.length; ++i) {
            Class<?>[] c = x[i].getParameterTypes();
            if (c.length != argc.length) continue;
            for (int j = 0; j < c.length; ++j) {
                if (!c[j].isAssignableFrom(argc[j])) continue block0;
            }
            return x[i];
        }
        throw new NoSuchMethodException("No suitable constructor for class " + this.m_c);
    }

    public Class getSourceClass() {
        return this.m_c;
    }
}

