/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.time.Duration;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.MessagingService;

public class AgentHeartBeatService
implements ServiceLifecycle,
AgentService,
HasLifecycle {
    public static final String AGENT_HEARTBEAT_TASK = "heartbeat";
    private boolean publishHeartbeat = true;
    private boolean forceHeartbeatPublication = false;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService agentPeriodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MessagingService messagingService;

    @Override
    public String getAgentServiceName() {
        return "heartBeatService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return true;
    }

    @Override
    public void build() {
        this.forceHeartbeatPublication = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.heartbeat.force.publication", "false").toLowerCase().equals("true");
        this.publishHeartbeat = this.forceHeartbeatPublication ? true : this.messagingService.getMessagingAccess().needsHeartbeat();
        AgentPeriodicTask heartbeatPublisher = new AgentPeriodicTask(AGENT_HEARTBEAT_TASK, () -> this.publishHeartBeatNow(false)).withPeriod(Duration.ofSeconds(1L));
        this.agentPeriodicTaskService.scheduleAgentPeriodicTask(heartbeatPublisher);
    }

    public int getStatusBroadcastPeriod() {
        return (int)this.agentPeriodicTaskService.getPeriodicTaskPeriod(AGENT_HEARTBEAT_TASK).getSeconds();
    }

    private void publishHeartBeatNow(boolean force) {
        if (this.publishHeartbeat || force) {
            StatusHeartBeat shb = new StatusHeartBeat(this.getStatusBroadcastPeriod());
            this.agent.sendStatusMessage((StatusMessage)shb);
        }
    }

    public final void broadcastStatus() {
        this.publishHeartBeatNow(true);
    }

    public boolean isPublishingHeartbeat() {
        return this.publishHeartbeat;
    }
}

