/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class RestFileSystemOptions {
    public static final String CACHE_OPTIONS = "CacheOptions";
    public static final String CACHE_FALLBACK = "CacheFallback";
    public static final String CACHE_LOGGING = "CacheLogging";
    public static final String USE_SSL = "UseSSL";
    public static final String CACHE_LOCATION = "CacheLocation";
    public static final String ALLOW_ALTERNATE_CACHE_LOCATION = "CacheFallbackLocation";
    public static final String AUTH_TOKEN = "JWTToken";

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Object> map = new HashMap<String, Object>();

        public Builder cacheLocation(File location) {
            this.map.put(RestFileSystemOptions.CACHE_LOCATION, location);
            return this;
        }

        public Builder cacheLocation(Path location) {
            this.map.put(RestFileSystemOptions.CACHE_LOCATION, location);
            return this;
        }

        public Builder logging(boolean log) {
            this.map.put(RestFileSystemOptions.CACHE_LOGGING, log);
            return this;
        }

        public Builder set(CacheOptions option) {
            this.map.put(RestFileSystemOptions.CACHE_OPTIONS, (Object)option);
            return this;
        }

        public Builder set(SSLOptions option) {
            this.map.put(RestFileSystemOptions.USE_SSL, (Object)option);
            return this;
        }

        public Builder set(CacheFallback option) {
            this.map.put(RestFileSystemOptions.CACHE_FALLBACK, (Object)option);
            return this;
        }

        public Builder setAuthorizationToken(String token) {
            this.map.put(RestFileSystemOptions.AUTH_TOKEN, token);
            return this;
        }

        public Builder ignoreLockedCache(boolean allow) {
            this.map.put(RestFileSystemOptions.ALLOW_ALTERNATE_CACHE_LOCATION, allow);
            return this;
        }

        public Map<String, Object> build() {
            return this.map;
        }
    }

    public static enum SSLOptions {
        TRUE,
        FALSE,
        AUTO;

    }

    public static enum CacheFallback {
        NEVER,
        OFFLINE,
        ALWAYS;

    }

    public static enum CacheOptions {
        NONE,
        MEMORY_ONLY,
        MEMORY_AND_DISK;

    }
}

