package org.lsst.ccs.subsystem.pathfinder.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.border.TitledBorder;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
//import org.lsst.ccs.subsystem.pathfinder.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.pathfinder.constants.LatchState;
import org.lsst.ccs.subsystem.pathfinder.constants.ConditionState;
import org.lsst.ccs.subsystem.pathfinder.constants.DeviceState;
import org.lsst.ccs.subsystem.pathfinder.constants.PLCState;
import org.lsst.ccs.subsystem.pathfinder.constants.SwitchEnable;
import org.lsst.ccs.subsystem.pathfinder.constants.SwitchState;
import org.lsst.ccs.subsystem.pathfinder.data.VacSysState;

import org.lsst.ccs.subsystem.pathfinder.constants.FanState;
import org.lsst.ccs.subsystem.pathfinder.constants.UtilTrunkFans;

/**
 *  Implements the utility monitoring panel.
 *
 *  @author Owen Saxton
 */
//public class PathfinderControlPanel extends javax.swing.JPanel {
public class PathfinderControlPanel extends JPanel implements UiUtilities.ActionHandler, CommandSender.ReplyHandler {

    static final Font FONT = new java.awt.Font("Tahoma", 1, 12);
    static final Color RED = new Color(175, 0, 0), GREEN = new Color(0, 175, 0),
                       BLUE = new Color(0, 75, 175), PURPLE = new Color(175, 0, 175);
    static final int SWTP_PUMP = 0, SWTP_VALVE = 1;
    static final String[] switchNames = new String[VacSysState.NUM_SWITCHES];
    static {
	switchNames[VacSysState.SW_HX_TURBO] = "Hx Turbo Pump";
	switchNames[VacSysState.SW_HX_ION_PUMP1] = "Hx Ion Pump";
        switchNames[VacSysState.SW_HX_VALVE] = "Hx Gate Valve";
    }
    static final int[] switchTypes = new int[VacSysState.NUM_SWITCHES];
    static {
	switchTypes[VacSysState.SW_HX_TURBO] = SWTP_PUMP;
	switchTypes[VacSysState.SW_HX_ION_PUMP1] = SWTP_PUMP;
        switchTypes[VacSysState.SW_HX_VALVE] = SWTP_VALVE;
    }



    private static final String[] latchNames = new String[VacSysState.NUM_LATCHES];
    static {
        latchNames[VacSysState.LATCH_CR_GATE_AO]  = "Cryo Gate Can't Open";
        latchNames[VacSysState.LATCH_CR_GATE_NFC] = "Cryo Gate Forced Shut";
        latchNames[VacSysState.LATCH_CR_VACUUM]   = "Cryo Vacuum Bad";
        latchNames[VacSysState.LATCH_CR_PUMP]     = "Cryo Turbo Pump Bad";
        latchNames[VacSysState.LATCH_HX_GATE_AO]  = "Hx Gate Can't Open";
        latchNames[VacSysState.LATCH_HX_GATE_NFC] = "Hx Gate Forced Shut";
        latchNames[VacSysState.LATCH_HX_VACUUM]   = "Hx Vacuum Bad";
        latchNames[VacSysState.LATCH_HX_PUMP]     = "Hx Turbo Pump Bad";
    }
    private static final String[] conditionNames = new String[VacSysState.NUM_CONDITIONS];
    static {
        conditionNames[VacSysState.COND_CR_FORELINE_VAC] = "Cryo Foreline OK";
        conditionNames[VacSysState.COND_CR_TRB_PRESS_10] = "Cryo Turbo Pr < 10";
        conditionNames[VacSysState.COND_CR_TRB_PUMP_OFF] = "Cryo Turbo Pump Off";
        conditionNames[VacSysState.COND_CR_VACUUM_001]   = "Cryo Vacuum < 0.001";
        conditionNames[VacSysState.COND_CR_VACUUM_01]    = "Cryo Vacuum < 0.1";
        conditionNames[VacSysState.COND_HX_FORELINE_VAC] = "HX Foreline OK";
        conditionNames[VacSysState.COND_HX_TRB_PRESS_10] = "HX Turbo Pr < 10";
        conditionNames[VacSysState.COND_HX_TURBO_OFF]    = "HX Turbo Pump On";
        conditionNames[VacSysState.COND_HX_VACUUM_001]   = "HX Vacuum < 0.001";
        conditionNames[VacSysState.COND_HX_VACUUM_01]    = "HX Vacuum < 0.1";
    }
	/*
    private static final String[] latchNames = new String[VacSysState.NUM_LATCHES];
    static {
        latchNames[VacSysState.LATCH_HX_GATE_AO]  = "Hx Gate Can't Open";
        latchNames[VacSysState.LATCH_HX_GATE_NFC] = "Hx Gate Forced Shut";
        latchNames[VacSysState.LATCH_HX_VACUUM]   = "Hx Vacuum Bad";
        latchNames[VacSysState.LATCH_HX_PUMP]     = "Hx Turbo Pump Bad";
    }
    private static final String[] conditionNames = new String[VacSysState.NUM_CONDITIONS];
    static {
        conditionNames[VacSysState.COND_HX_FORELINE_VAC] = "HX Foreline OK";
        conditionNames[VacSysState.COND_HX_TRB_PRESS_10] = "HX Turbo Pr < 10";
        conditionNames[VacSysState.COND_HX_TURBO_OFF]    = "HX Turbo Pump Off";
        conditionNames[VacSysState.COND_HX_VACUUM_001]   = "HX Vacuum < 0.001";
        conditionNames[VacSysState.COND_HX_VACUUM_01]    = "HX Vacuum < 0.1";
    }
	*/

    private static final int sysStateWidth = UiUtilities.maxLabelWidth(new String[]{"RUNNING", "STOPPED"}, "");
    private static final int plcStateWidth = UiUtilities.maxEnumLabelWidth(PLCState.class);
    private static final int switchStatusWidth = Math.max(UiUtilities.maxEnumLabelWidth(SwitchState.class),
                                                          UiUtilities.maxEnumLabelWidth(DeviceState.class));
    private static final int latchStatusWidth = UiUtilities.maxEnumLabelWidth(LatchState.class);
    private static final int condStatusWidth = UiUtilities.maxEnumLabelWidth(ConditionState.class);
    private static final int FAN_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(FanState.class);

    /*
    static final String[] conditionNames = new String[VacSysState.NUM_CONDITIONS];
    static {
        conditionNames[VacSysState.COND_CR_GATE_AO] = "VAT Valve Can't Open";
        conditionNames[VacSysState.COND_CR_GATE_NFC] = "VAT Valve Forced Shut";
        conditionNames[VacSysState.COND_CR_VACUUM] = "Cryo Vacuum Bad";
        conditionNames[VacSysState.COND_CR_PUMP] = "Cryo Turbo Pump Bad";
        conditionNames[VacSysState.COND_HX_GATE_AO] = "Hx Gate Can't Open";
        conditionNames[VacSysState.COND_HX_GATE_NFC] = "Hx Gate Forced Shut";
        conditionNames[VacSysState.COND_HX_VACUUM] = "Hx Vacuum Bad";
        conditionNames[VacSysState.COND_HX_PUMP] = "Hx Turbo Pump Bad";
    }
    */

    final private CommandSender sender;
    private String subsys;
    private double mainPeriod = 5.0;


    private int switchMask = 0, latchMask = 0, conditionMask = 0;

    private final UiUtilities uiUtils;

    private final JPanel mainPanel = new JPanel();

    private final JPanel headPanel = new JPanel();
    private JLabel sysStateValue;
    private JLabel plcStateValue;
    private TextFieldX periodTextField;

    private final JLabel[] fanState = new JLabel[UtilTrunkFans.NUM_FANS];
    private final ButtonGroup[] fanBG = new ButtonGroup[UtilTrunkFans.NUM_FANS];
    private final JRadioButton[] fanOffRB = new JRadioButton[UtilTrunkFans.NUM_FANS];
    private final JRadioButton[] fanSpeedRB = new JRadioButton[UtilTrunkFans.NUM_FANS];
    private final TextFieldX[] fanSpeedTF = new TextFieldX[UtilTrunkFans.NUM_FANS];
    private final JRadioButton[] fanTempRB = new JRadioButton[UtilTrunkFans.NUM_FANS];
    private final TextFieldX[] fanTempTF = new TextFieldX[UtilTrunkFans.NUM_FANS];


    private final JLabel stateLabel = new JLabel("System State:  ");
    private final JLabel stateStatus = new JLabel("STOPPED");

    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    //    private final JTextField periodTextField = new JTextField();
    private final JLabel periodUnitsLabel = new JLabel("sec");

    //private final JPanel[] switchPanel = new JPanel[VacuumState.NUM_SWITCHES];
    private final JPanel switchPanel = new JPanel();
    private final JLabel[] switchLabel = new JLabel[VacSysState.NUM_SWITCHES];
    private final JLabel[] switchStatus = new JLabel[VacSysState.NUM_SWITCHES];
    private final ButtonGroup[] switchBG = new ButtonGroup[VacSysState.NUM_SWITCHES];
    private final JRadioButton[] switchOffRB = new JRadioButton[VacSysState.NUM_SWITCHES];
    private final JRadioButton[] switchOnRB = new JRadioButton[VacSysState.NUM_SWITCHES];


    private JPanel latchPanel;
    private final JLabel[] latchLabel = new JLabel[VacSysState.NUM_LATCHES];
    private final JLabel[] latchStatus = new JLabel[VacSysState.NUM_LATCHES];
    private final JButton[] latchResetBtn = new JButton[VacSysState.NUM_LATCHES];


    private JPanel conditionPanel;
    private final JLabel[] conditionLabel = new JLabel[VacSysState.NUM_CONDITIONS];
    private final JLabel[] conditionStatus = new JLabel[VacSysState.NUM_CONDITIONS];

    private final JButton[] conditionResetBtn = new JButton[VacSysState.NUM_CONDITIONS];

    private JPanel utPanel;





    public PathfinderControlPanel(String subsys) {
        uiUtils = new UiUtilities(this);
        sender = new CommandSender(subsys, this);
        initComponents();
        (new DisablePanel()).run();
    }
    /*    public PathfinderControlPanel(CommandSender cons) {
        this.sender = cons;
        uiUtils = new UiUtilities(this);
	//        sender = new CommandSender(subsys, this);

        initComponents();
        (new UpdateVacStatus(new VacSysState())).run();
        (new DisableSystem()).run();
    }
    */

    public void setSubsystem(String name) {
        this.subsys = name;
    }

    private void initComponents() {

        // System status line                                                                                               
        sysStateValue = UiUtilities.newLabel("X", sysStateWidth);
        plcStateValue = UiUtilities.newLabel("X", plcStateWidth);
        periodTextField = uiUtils.newTextFieldX("00000.0", "U", TextFieldX.TYPE_DOUBLE);

         // System state
        stateLabel.setFont(FONT);
        stateStatus.setFont(FONT);
        Dimension d = stateStatus.getPreferredSize();
        d.width = 150;
        stateStatus.setMinimumSize(d);
        stateStatus.setPreferredSize(d);

        // Update period
        periodLabel.setFont(FONT);
        d = periodTextField.getPreferredSize();
        d.width = 45;
        periodTextField.setMinimumSize(d);
        periodTextField.setPreferredSize(d);
        periodTextField.setHorizontalAlignment(SwingConstants.CENTER);
        periodTextField.setText("...");
        periodTextField.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent evt) {
                setUpdatePeriod();
            }
        });
        periodUnitsLabel.setFont(FONT);

        // Fan control elements                                                                                                  
        for (int fanId = 0; fanId < UtilTrunkFans.NUM_FANS; fanId++) {
            fanState[fanId] = UiUtilities.newLabel("XXX", FAN_STATE_WIDTH);
            fanOffRB[fanId] = uiUtils.newRadioButton("Off", "FF" + fanId);
            fanSpeedRB[fanId] = uiUtils.newRadioButton("Speed", "FS" + fanId);
            fanTempRB[fanId] = uiUtils.newRadioButton("Delta Temp", "FT" + fanId);
            ButtonGroup bg = fanBG[fanId] = new ButtonGroup();
            bg.add(fanOffRB[fanId]);
            bg.add(fanSpeedRB[fanId]);
            bg.add(fanTempRB[fanId]);
            fanSpeedTF[fanId] = uiUtils.newTextFieldX("0000.00", "S" + fanId, TextFieldX.TYPE_DOUBLE, true);
            fanTempTF[fanId] = uiUtils.newTextFieldX("0000.00", "T" + fanId, TextFieldX.TYPE_DOUBLE, true);
        }



        // Switch states
        for (int sw = 0; sw < VacSysState.NUM_SWITCHES; sw++) {
            JLabel label = switchLabel[sw] = new JLabel(switchNames[sw]);
            label.setFont(FONT);
            d = label.getPreferredSize();
            d.width = 130;
            label.setMinimumSize(d);
            label.setPreferredSize(d);
            label = switchStatus[sw] = new JLabel("XXX");
            label.setFont(FONT);
            d = label.getPreferredSize();
            d.width = 80;
            label.setMinimumSize(d);
            label.setPreferredSize(d);
            int swType = switchTypes[sw];
            JRadioButton buttonOff = switchOffRB[sw] = new JRadioButton(swType == SWTP_PUMP ? "Off" : "Shut");
            buttonOff.setFont(FONT);
            //buttonOff.setText("Off");
            buttonOff.setFocusable(false);
            buttonOff.setName(Integer.toString(sw));
            buttonOff.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    setSwitchOn(Integer.valueOf(name), false);
                }
            });
            JRadioButton buttonOn = switchOnRB[sw] = new JRadioButton(swType == SWTP_PUMP ? "On" : "Open");
            buttonOn.setFont(FONT);
            //buttonOn.setText("On");
            buttonOn.setFocusable(false);
            buttonOn.setName(Integer.toString(sw));
            buttonOn.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    setSwitchOn(Integer.valueOf(name), true);
                }
            });
            ButtonGroup bg = switchBG[sw] = new ButtonGroup();
            bg.add(buttonOff);
            bg.add(buttonOn);
        }

        // Latched condition states                                                                                                                      
        for (int cond = 0; cond < VacSysState.NUM_LATCHES; cond++) {
	    //	    if (latchNames[cond].length()>0) {
		latchLabel[cond] = UiUtilities.newLabel(latchNames[cond] + ":", 0);
		latchStatus[cond] = UiUtilities.newLabel("X", latchStatusWidth);
		latchResetBtn[cond] = uiUtils.newButton("Reset", "R" + cond, true);
		//	    }
		JButton button = latchResetBtn[cond];
		// = new JButton("Reset");
		Insets i = button.getMargin();
		i.left -= 3;
		i.right -= 3;
		button.setMargin(i);
		d = button.getPreferredSize();
		//d.height -= 9;
		button.setPreferredSize(d);
		button.setFont(UiConstants.FONT);
		button.setFocusable(false);
		button.setName(Integer.toString(cond));
		button.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JButton)evt.getSource()).getName();
                    clearLatch(Integer.valueOf(name));
                }
		    });

	}


        // Condition states                                                                                                                              
        for (int cond = 0; cond < VacSysState.NUM_CONDITIONS; cond++) {
	    //	    if (conditionNames[cond].length()>0) {
		conditionLabel[cond] = UiUtilities.newLabel(conditionNames[cond] + ":", 0);
		conditionStatus[cond] = UiUtilities.newLabel("X", condStatusWidth);
		//	    }
	}


        // Lay out all the sub-panels
        periodPanel.add(periodTextField);
        periodPanel.add(periodUnitsLabel);


        // System status line (panel)                                                                                       
        headPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 0, 5, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = GridBagConstraints.WEST;
	gbh.insets.left = 5;
        headPanel.add(UiUtilities.newLabel("System State: ", 0), gbh);
        gbh.gridx++;
        headPanel.add(sysStateValue, gbh);
        gbh.gridx++;
        gbh.insets.left = 25;
        headPanel.add(UiUtilities.newLabel("PLC State: ", 0), gbh);
        gbh.gridx++;
        gbh.insets.left = 5;
        headPanel.add(plcStateValue, gbh);
	gbh.gridx++;
	gbh.insets.left = 25;
        headPanel.add(UiUtilities.newLabel("Update Period: ", 0), gbh);
        gbh.gridx++;
        gbh.insets.left = 5;
	headPanel.add(periodTextField, gbh);
	gbh.gridx++;
        gbh.insets.right = 5;
        headPanel.add(UiUtilities.newLabel("sec", 0), gbh);


        // Prepare the switch panel
        TitledBorder border = BorderFactory.createTitledBorder("Switches");
        border.setTitleJustification(TitledBorder.CENTER);
        switchPanel.setBorder(border);
        switchPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.gridx = 0;
        gbs.gridy = 0;
        gbs.insets.bottom = -8;
        switchPanel.add(new JLabel(" "), gbs);

	// Prepare the latched conditions panel                                                                                                           
        latchPanel = UiUtilities.newBorderedPanel("PLC Error Conditions");
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.gridx = 0;
        gbl.gridy = 0;
	gbl.insets.bottom = -8;
        latchPanel.add(new JLabel(" "), gbl);

	// Prepare the conditions panel                                                                                                                   
        conditionPanel = UiUtilities.newBorderedPanel("PLC Running Conditions");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
	gbc.gridy = 0;
        gbc.insets.bottom = -8;
	conditionPanel.add(new JLabel(" "), gbc);


	// UT cooling control panel                                                                                              
        utPanel = UiUtilities.newBorderedPanel("UT Cooling Control");
        GridBagConstraints gbu = new GridBagConstraints();
        gbu.anchor = GridBagConstraints.WEST;
	gbl.insets.bottom = -8;
	//        gbu.insets = new Insets(4, 4, 0, 4);
        gbu.gridx = 0;
        gbu.gridy = 0;
        addFanLine(UtilTrunkFans.FAN_UT_ID, utPanel, gbu);
	/*
        gbu.gridy++;
        gbu.insets.top = 0;
        gbu.gridx = 0;
        gbu.insets.bottom = 4;
        addValveLine(UtilTrunkValves.VALVE_UT_ID, utPanel, gbu);
	*/
        utPanel.setMinimumSize(utPanel.getPreferredSize());

        // Lay out the main panel
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(0, 0, 0, 0);
        gbm.anchor = GridBagConstraints.NORTH;
        gbm.gridx = 0;
        gbm.gridy = 0;
        mainPanel.add(headPanel, gbm);
        gbm.gridy++;
        mainPanel.add(switchPanel, gbm);
        gbm.gridy++;
        mainPanel.add(latchPanel, gbm);
        gbm.gridy++;
        mainPanel.add(conditionPanel, gbm);
        gbm.gridy++;
        mainPanel.add(utPanel, gbm);



        // Lay out the complete panel
        add(mainPanel);

    }

    private void updateSwitchLayout(int switches) {
        for (int sw = 0; sw < VacSysState.NUM_SWITCHES; sw++) {
            if ((switchMask & (1 << sw)) != 0) {
                switchPanel.remove(switchLabel[sw]);
                switchPanel.remove(switchStatus[sw]);
                switchPanel.remove(switchOffRB[sw]);
                switchPanel.remove(switchOnRB[sw]);
            }
        }
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = GridBagConstraints.NORTHWEST;
        gbs.gridy = 0;
        int colm = 0;
        for (int sw = 0; sw < VacSysState.NUM_SWITCHES; sw++) {
            if ((switches & (1 << sw)) != 0) {
                if (colm == 0) {
                    gbs.gridx = 0;
                    gbs.gridy++;
                }
                gbs.insets.top = 0;
                gbs.insets.left = colm == 0 ? 4 : 50;
                //gbs.anchor = GridBagConstraints.NORTHEAST;
                switchPanel.add(switchLabel[sw], gbs);
                gbs.insets.left = 0;
                gbs.gridx++;
                //gbs.anchor = GridBagConstraints.NORTHWEST;
                switchPanel.add(switchStatus[sw], gbs);
                gbs.gridx++;
                gbs.insets.top = -4;
                switchPanel.add(switchOffRB[sw], gbs);
                gbs.gridx++;
                gbs.insets.left = 6;
                gbs.insets.right = 3;
                switchPanel.add(switchOnRB[sw], gbs);
                gbs.insets.right = 0;
                gbs.gridx++;
                colm = (colm + 1) % 2;
            }
        }
        switchMask = switches;
    }


    private void updateLatchLayout(int conditions) {
        for (int cond = 0; cond < VacSysState.NUM_LATCHES; cond++) {
            if ((latchMask & (1 << cond)) != 0) {
                latchPanel.remove(latchLabel[cond]);
                latchPanel.remove(latchStatus[cond]);
                latchPanel.remove(latchResetBtn[cond]);
            }
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = -1;
        int colm = 0;
        for (int cond = 0; cond < VacSysState.NUM_LATCHES; cond++) {
            if ((conditions & (1 << cond)) != 0) {
                if (colm == 0) {
                    gbc.gridx = 0;
                    gbc.gridy++;
                }
                gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
                gbc.insets.left = colm == 0 ? 4 : 40;
                latchPanel.add(latchLabel[cond], gbc);
                gbc.insets.left = 4;
                gbc.gridx++;
                latchPanel.add(latchStatus[cond], gbc);
                gbc.gridx++;
                latchPanel.add(latchResetBtn[cond], gbc);
                gbc.gridx++;
                colm = (colm + 1) % 2;
            }
        }
        latchMask = conditions;
    }

    private void updateConditionLayout(int conditions) {
        for (int cond = 0; cond < VacSysState.NUM_LATCHES; cond++) {
            if ((conditionMask & (1 << cond)) != 0) {
                conditionPanel.remove(conditionLabel[cond]);
                conditionPanel.remove(conditionStatus[cond]);
            }
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = -1;
        int colm = 0;
        for (int cond = 0; cond < VacSysState.NUM_CONDITIONS; cond++) {
            if ((conditions & (1 << cond)) != 0) {
                if (colm == 0) {
                    gbc.gridx = 0;
                    gbc.gridy++;
                }
                gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
                gbc.insets.left = colm == 0 ? 4 : 40;
                conditionPanel.add(conditionLabel[cond], gbc);
                gbc.gridx++;
                gbc.insets.left = 4;
                conditionPanel.add(conditionStatus[cond], gbc);
                gbc.gridx++;
                colm = (colm + 1) % 2;
            }
        }
        conditionMask = conditions;
    }



    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(periodTextField.getText());
            sender.sendCommand(subsys, "setUpdatePeriod", (int)(1000 * value));
            periodTextField.setEnabled(false);
        }
        catch(NumberFormatException nfe) {
            periodTextField.setText(String.valueOf(mainPeriod));
        }
    }

    private void setSwitchOn(int sw, boolean value) {
        switchOffRB[sw].setEnabled(false);
        switchOnRB[sw].setEnabled(false);
        sender.sendCommand(subsys, "setSwitchOn", sw, value);
    }
    /*    
    @Override
    public void handleRadioButton(String name) {
        char type = name.charAt(0);
        int sw = Integer.valueOf(name.substring(1));
        switchOffRB[sw].setEnabled(false);
        switchOnRB[sw].setEnabled(false);
        sender.sendCommand(null, "setNamedSwitchOn", SwitchNames.ID_MAP.get(sw), type == 'O');
    }

    @Override
    public void handleButton(String name) {
        int cond = Integer.valueOf(name.substring(1));
        latchResetBtn[cond].setEnabled(false);
        sender.sendCommand(null, "clearLatch", cond);
    }
    */

    @Override
    public void handleRadioButton(String name) {
        char type = name.charAt(0);
        char action = name.charAt(1);
        int id = Integer.valueOf(name.substring(2));
        switch (type) {
        case 'F':
            FanState fState = action == 'T' ? FanState.TEMP : action == 'S' ? FanState.SPEED : FanState.OFF;
            sender.sendCommand(null, "setFanState", UtilTrunkFans.getName(id), fState);
            break;
        }
    }

    @Override
    public void handleTextFieldX(String name, Object value) {
        char type = name.charAt(0);
        int id = Integer.valueOf(name.substring(1));
        switch (type) {
        case 'S':
            sender.sendCommand(null, "setFanSpeed", UtilTrunkFans.getName(id), (Double)value);
            break;
        case 'T':
            sender.sendCommand(null, "setFanDeltaTemp", UtilTrunkFans.getName(id), (Double)value);
            break;
        }
    }


    public void clearLatch(int cond) {
        latchResetBtn[cond].setEnabled(false);
        sender.sendCommand(null, "clearLatch", cond);
    }

    private void clearCondition(int cond) {
        conditionResetBtn[cond].setEnabled(false);
        sender.sendCommand(subsys, "clearCondition", cond);
    }


    private void addFanLine(int fanId, JPanel panel, GridBagConstraints gbc) {
        panel.add(UiUtilities.newLabel("Fan:", 0), gbc);
        gbc.gridx++;
        gbc.insets.left = 4;
        panel.add(fanState[fanId], gbc);
        gbc.gridx++;
        panel.add(fanOffRB[fanId], gbc);
        gbc.gridx++;
        panel.add(fanSpeedRB[fanId], gbc);
        gbc.gridx++;
        panel.add(fanSpeedTF[fanId], gbc);
        gbc.gridx++;
        gbc.insets.left = 0;
        panel.add(UiUtilities.newLabel("D/C", 0), gbc);
        gbc.insets.left = 4;
        gbc.gridx++;
        if (UtilTrunkFans.hasTempState(fanId)) {
            panel.add(fanTempRB[fanId], gbc);
            gbc.gridx++;
            panel.add(fanTempTF[fanId], gbc);
            gbc.gridx++;
            gbc.insets.left = 0;
            panel.add(UiUtilities.newLabel("\u00b0C", 0), gbc);
            gbc.insets.left = 4;
            gbc.gridx++;
        }
    }


    
    public void initPanel() {
	sender.sendCommand(true, null, "getVacuumState");
    }

    @Override
    public void onCommandReply(Object reply, String path, String command, Object[] args) {
	updatePanel((VacSysState)reply);
    }

    public void updatePanel(VacSysState rs) {
        SwingUtilities.invokeLater(new UpdateVacStatus(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }
    /*
    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }
    */
    /*
    private void setControlState(int value) {
        fanControlOffRB.setEnabled(false);
        fanControlManualRB.setEnabled(false);
        fanControlAutoRB.setEnabled(false);
        gui.sendCommand(null, "setControlState", value);
    }
    */


    class UpdateVacStatus implements Runnable {

        private final VacSysState vs;
	private final Logger sLog = Logger.getLogger("org.lsst.ccs.subsystem.pathfinder.ui.PathfinderControlPanel");



        UpdateVacStatus(VacSysState vs) {
            this.vs = vs;
        }

        @Override
        public void run() {

            sysStateValue.setText("RUNNING");
            sysStateValue.setForeground(UiConstants.GREEN);
            PLCState plcState = vs.getPlcState();
	    plcStateValue.setText(plcState.name());
            plcStateValue.setForeground(plcState == PLCState.ALIVE ? UiConstants.GREEN :
                                        plcState == PLCState.OFFLINE ? UiConstants.BLUE : UiConstants.RED);
            plcStateValue.setEnabled(true);
            periodTextField.update(vs.getTickMillis() / 1000.0, true);

	    /*            stateStatus.setText("RUNNING");
            stateStatus.setForeground(GREEN);
            periodTextField.setEnabled(true);
            mainPeriod = vs.getTickMillis() / 1000.0;
            periodTextField.setText(String.valueOf(mainPeriod));
	    */

            for (int fanId = 0; fanId < UtilTrunkFans.NUM_FANS; fanId++) {
                FanState st = vs.getFanState(fanId);
                st = st == null ? FanState.OFFLINE : st;
                JLabel label = fanState[fanId];
                label.setText(st.toString());
                label.setForeground(st == FanState.TEMP ? UiConstants.GREEN : st == FanState.SPEED ? UiConstants.YELLOW :
                                    st == FanState.OFF ? Color.BLACK : UiConstants.BLUE);
                st = vs.getFanBaseState(fanId);
                JRadioButton selButton = st == FanState.TEMP ? fanTempRB[fanId] :
		    st == FanState.SPEED ? fanSpeedRB[fanId] : fanOffRB[fanId];
                selButton.setSelected(true);
                fanSpeedTF[fanId].update(vs.getFanSpeed(fanId), true);
                fanTempTF[fanId].update(vs.getDeltaTemp(fanId), true);
                fanState[fanId].setEnabled(true);
                fanOffRB[fanId].setEnabled(true);
                fanSpeedRB[fanId].setEnabled(true);
                fanTempRB[fanId].setEnabled(true);
            }



            int switches = 0;
            for (int sw = 0; sw < VacSysState.NUM_SWITCHES; sw++) {
                if (!vs.hasSwitch(sw)) continue;
                switches |= (1 << sw);
                SwitchState state = vs.getSwitchState(sw);

                String text;
                Color color;
                SwitchEnable enable = vs.getSwitchEnable(sw);
                if (enable == SwitchEnable.OFF || enable == SwitchEnable.WAS_OFF) {
                    text = "DISABLD";
                    color = RED;
                }
                else {
                    text = state.name();
                    if (switchTypes[sw] == SWTP_VALVE) {
                        text = state == SwitchState.OFF ? "SHUT" : state == SwitchState.ON ? "OPEN" : text;
                    }
                    color = state == SwitchState.OFF ? Color.black : state == SwitchState.ON ? GREEN : BLUE;
                    DeviceState devState = vs.getDeviceState(sw);
                    if (devState != null && state != SwitchState.OFFLINE) {
                        text = devState.name();
                        if (devState == DeviceState.FAILED) {
                            color = RED;
                        }
                    }
                }
                switchStatus[sw].setText(text);
                switchStatus[sw].setForeground(color);

                JRadioButton selButton = state == SwitchState.ON ? switchOnRB[sw] : switchOffRB[sw];
                selButton.setSelected(true);
                switchStatus[sw].setEnabled(true);
                switchOffRB[sw].setEnabled(true);
                switchOnRB[sw].setEnabled(true);
            }
            if (switches != switchMask) {
                updateSwitchLayout(switches);
            }



            int conditions = 0;
            for (int cond = 0; cond < VacSysState.NUM_LATCHES; cond++) {
                if (!vs.hasLatch(cond)) continue;
                conditions |= (1 << cond);
                LatchState state = vs.getLatch(cond);
		//		if ((latchMask & (1 << cond)) != 0) {

		    sLog.info("PathfinderControlPanel: cond = "+cond+" name = "+state.name()+" length of latchStatus is "+latchStatus.length);

		    sLog.info("PathfinderControlPanel: latchStatus = "+latchStatus);

		    latchStatus[cond].setText(state.name());
		    latchStatus[cond].setForeground(state == LatchState.OFFLINE ? UiConstants.BLUE :
                                                state == LatchState.CLEAR ? UiConstants.GREEN :
						state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE);
		    latchStatus[cond].setEnabled(true);
		    latchResetBtn[cond].setEnabled(true);
		    //		}
            }
            if (conditions != latchMask) {
                updateLatchLayout(conditions);
            }
            conditions = 0;
            for (int cond = 0; cond < VacSysState.NUM_CONDITIONS; cond++) {
                if (!vs.hasCondition(cond)) continue;
                conditions |= (1 << cond);
                ConditionState state = vs.getCondition(cond);
		conditionStatus[cond].setText(state.name());
                conditionStatus[cond].setForeground(state == ConditionState.OFF ? UiConstants.BLUE :
                                                    state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN);
                conditionStatus[cond].setEnabled(true);
	    }
            if (conditions != conditionMask) {
                updateConditionLayout(conditions);
            }



        }

    }

    class DisablePanel implements Runnable {

	@Override
        public void run() {

            sysStateValue.setText("STOPPED");
            sysStateValue.setForeground(UiConstants.RED);
            plcStateValue.setEnabled(false);
            periodTextField.setDisabled();

            for (int fanId = 0; fanId < UtilTrunkFans.NUM_FANS; fanId++) {
                fanState[fanId].setEnabled(false);
                fanOffRB[fanId].setEnabled(false);
                fanSpeedRB[fanId].setEnabled(false);
                fanTempRB[fanId].setEnabled(false);
                fanSpeedTF[fanId].setDisabled();
                fanTempTF[fanId].setDisabled();
            }

            for (int sw = 0; sw < VacSysState.NUM_SWITCHES; sw++) {
                switchStatus[sw].setEnabled(false);
                switchOffRB[sw].setEnabled(false);
		switchOnRB[sw].setEnabled(false);
            }
            for (int cond = 0; cond < VacSysState.NUM_LATCHES; cond++) {
		try {
		    latchStatus[cond].setEnabled(false);
		    latchResetBtn[cond].setEnabled(false);
		} catch(NullPointerException npe) {
		    break;
		} 
            }
            for (int cond = 0; cond < VacSysState.NUM_CONDITIONS; cond++) {
		try {
		    conditionStatus[cond].setEnabled(false);
		} catch(NullPointerException npe) {
		    break;
		} 
            }
        }
    }

    /*
class DisableSystem implements Runnable {

        @Override
        public void run() {

            sysStateValue.setText("STOPPED");
            sysStateValue.setForeground(UiConstants.RED);
            plcStateValue.setEnabled(false);
	    periodTextField.setDisabled();

	    /*
            stateStatus.setText("STOPPED");
            stateStatus.setForeground(RED);
            periodTextField.setEnabled(false);
	    * /

            for (int sw = 0; sw < VacSysState.NUM_SWITCHES; sw++) {
                switchStatus[sw].setEnabled(false);
                switchOffRB[sw].setEnabled(false);
                switchOnRB[sw].setEnabled(false);
            }
            for (int cond = 0; cond < VacSysState.NUM_CONDITIONS; cond++) {
                conditionStatus[cond].setEnabled(false);
                conditionResetBtn[cond].setEnabled(false);
            }
        } 
    }
*/
    private static final long serialVersionUID = 1L;
}
