package org.lsst.ccs.subsystem.pathfinder.ui.jas;

import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.pathfinder.data.PathfinderAgentProperties;
import org.lsst.ccs.subsystem.pathfinder.data.VacSysState;
import org.lsst.ccs.subsystem.pathfinder.ui.PathfinderControlPanel;
import org.lsst.ccs.subsystem.pathfinder.ui.PathfinderPage;

/**
 *
 * @author tonyj
 */
@Plugin(name = "Pathfinder Plugin", description = "Pathfinder Plugin")
public class PathfinderControlPlugin extends ConsolePlugin {

    @Override
    public void initialize() {
        OptionalPage.getService().add(new MonOptionalPage(PathfinderAgentProperties.PATHFINDER_TYPE_AGENT_PROPERTY, PathfinderControl.class, "Control", true));
        OptionalPage.getService().add(new VacImageOptionalPage());
    }
    
    public static class PathfinderControl extends ControlPanel implements StatusMessageListener {

        private PathfinderControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(VacSysState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public JPanel getControlPanel(String agent) {
            return ctrlPanel = new PathfinderControlPanel(agent);
        }

        @Override
        public void initControlPanel() {
            ctrlPanel.initPanel();
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updatePanel((VacSysState)obj);
        }

        @Override
        public void disableControlPanel() {
            ctrlPanel.disablePanel();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }

    }
    
    static class VacImageOptionalPage implements OptionalPage {
        
        private PathfinderPage pathfinderPage;

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty(PathfinderAgentProperties.PATHFINDER_TYPE_AGENT_PROPERTY)
                     ? "CCS Subsystems/" + agent.getName() + "/Schematic" : null;
        }
        
        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            pathfinderPage = new PathfinderPage(agent);
            JComponent panel = pathfinderPage.getView().getPanel();
            panel.setName(agent.getName() + " Schematic");
            return panel;
        }

        @Override
        public void opened(String page) {
            pathfinderPage.getView().install();
        }

        @Override
        public void closed(String page) {
            pathfinderPage.getView().uninstall();
            pathfinderPage = null;
        }
    }

}
