package org.lsst.ccs.subsystem.pathfinder.data;

import org.lsst.ccs.utilities.logging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.messages.StatusMessage;

/**
 ***************************************************************************
 **
 ** Contains the state of the pathfinder system * * @author Homer Neal *
 * **************************************************************************
 */
public class PathfinderConfig implements Serializable {

    public enum operating_states {

        IDLE, READY, TEST, ACQ1, WARM, ACQ3, ACQ4, ACQ5, EXPERT;
    }
    public static final String[] COMPONENT_NAMES = {"IDLE", "READY", "TEST", "ACQ1", "WARM"};

    public enum EVENT_ID {

        BIAS,
        CRYO,
        VAC,
        PD,
        LMP;
    }
    

    public static int MAXSTATES = operating_states.values().length;
    private int cfgstate = 0;

    private String configFile;

    public PathfinderConfig() {
    }


}
