package org.lsst.ccs.subsystem.pathfinder.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.pathfinder.data.VacuumException;

/**
 * Utility trunk fan definitions.
 *
 * @author The CCS team
 */
public class UtilTrunkFans {

    public static final String
        FAN_UT  = "UtFan";

    public static final int
        FAN_UT_ID  = 0,
        NUM_FANS = 1;

    private static final Map<Integer, Integer> fanSwitchMap = new LinkedHashMap<>();
    static {

    }

    private static final Map<String, Integer> fanNameToId = new LinkedHashMap<>();
    static {
        fanNameToId.put(FAN_UT, FAN_UT_ID);
    }

    private static final Map<Integer, String> fanIdToName = new LinkedHashMap<>();
    static {
        for (Map.Entry entry : fanNameToId.entrySet()) {
            fanIdToName.put((Integer)entry.getValue(), (String)entry.getKey());
        }
    }

    private static final boolean[] hasTempState = new boolean[NUM_FANS];
    static {
        hasTempState[FAN_UT_ID] = true;
    }

    /**
     *  Gets the list of fan names.
     * 
     *  @return  The list of names
     */
    public static List<String> getNames()
    {
        return new ArrayList<>(fanNameToId.keySet());
    }

    /**
     *  Gets a fan name from its ID.
     * 
     *  @param  id  The fan id
     *  @return  The fan name
     */
    public static String getName(int id)
    {
        return fanIdToName.get(id);
    }

    /**
     *  Gets a fan ID from its name.
     * 
     *  @param  name  The fan name
     *  @return  The fan ID
     *  @throws  VacuumException
     */
    public static int getId(String name) throws VacuumException
    {
        Integer id = fanNameToId.get(name);
        if (id == null) {
            throw new VacuumException("Invalid fan name: " + name);
        }
        return id;
    }

    /**
     *  Gets a fan switch from its ID.
     * 
     *  @param  id  The fan ID
     *  @return  The fan switch ID
     */
    public static Integer getSwitch(int id)
    {
        return fanSwitchMap.get(id);
    }

    /**
     *  Gets whether a fan has a temperature control state.
     * 
     *  @param  id  The fan id
     *  @return  Whether it has a TEMP state
     */
    public static boolean hasTempState(int id)
    {
        return hasTempState[id];
    }

}
