package org.lsst.ccs.subsystem.pathfinder.constants;

/**
 *  Definitions for the vacuum system devices.
 *
 *  @author The CCS team
 */
public class Devices {

    public static final int
        DEVC_PLUTO           = 0,
        DEVC_ION_PUMP        = 1,
    //        DEVC_CRYO_TURBO_PUMP = 2,
        DEVC_HX_TURBO_PUMP   = 3,
    //        DEVC_PDU             = 4,
        NUM_DEVICES          = 3;

    private static final String[] descriptions = new String[NUM_DEVICES];
    static {
        descriptions[DEVC_PLUTO] = "Pluto";
        descriptions[DEVC_ION_PUMP] = "Ion pump";
	//        descriptions[DEVC_CRYO_TURBO_PUMP] = "Cryo turbo pump";
	descriptions[DEVC_HX_TURBO_PUMP] = "HX turbo pump";
	//        descriptions[DEVC_PDU] = "PDU";
    }

    /**
     *  Gets a device description.
     * 
     *  @param  id  The device ID
     *  @return  The device description
     */
    public static String getDescription(int id)
    {
        return descriptions[id];
    }

}
