package org.lsst.ccs.subsystem.pathfinder.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.subsystem.pathfinder.constants.CmprSetState;
import org.lsst.ccs.subsystem.pathfinder.constants.HexCmprState;
import org.lsst.ccs.subsystem.pathfinder.constants.HexValves;
import org.lsst.ccs.subsystem.pathfinder.constants.ValvePosnState;
import org.lsst.ccs.subsystem.pathfinder.constants.ValveSetState;

/**
 *  Contains the heat exchanger system state
 *
 *  @author Owen Saxton
 */
public class HexValveState implements Serializable {
    
    public static final String KEY = "HexValveState";
    private int tickMillis;           // Data status update period (ms)
    private final HexCmprState[] hexState = new HexCmprState[HexValves.NUM_HEXS];
    private final CmprSetState[] cmprState = new CmprSetState[HexValves.NUM_CMPRS];
    private final ValveSetState[] setState = new ValveSetState[HexValves.NUM_VALVES];
    private final ValvePosnState[] posnState = new ValvePosnState[HexValves.NUM_VALVES];

    public HexValveState() {
        Arrays.fill(hexState, HexCmprState.OFFLINE);
        Arrays.fill(cmprState, CmprSetState.OFFLINE);
        Arrays.fill(setState, ValveSetState.OFFLINE);
        Arrays.fill(posnState, ValvePosnState.OFFLINE);
    }

    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setHexState(int hex, HexCmprState state) {
        hexState[hex] = state;
    }

    public HexCmprState getHexState(int hex) {
        return hexState[hex];
    }

    public void setCmprState(int cmpr, CmprSetState state) {
        cmprState[cmpr] = state;
    }

    public CmprSetState getCmprState(int cmpr) {
        return cmprState[cmpr];
    }

    public void setSetState(int valve, ValveSetState state) {
        setState[valve] = state;
    }

    public ValveSetState getSetState(int valve) {
        return setState[valve];
    }

    public void setPosnState(int valve, ValvePosnState state) {
        posnState[valve] = state;
    }

    public ValvePosnState getPosnState(int valve) {
        return posnState[valve];
    }

    @Override
    public String toString() {
        return super.toString();  // Replace this
    }

    private static final long serialVersionUID = -2045605058683173781L;
}
