package org.lsst.ccs.subsystem.pathfinder.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.pathfinder.constants.FanState;
//import org.lsst.ccs.subsystem.pathfinder.constants.HeaterState;
import org.lsst.ccs.subsystem.pathfinder.constants.UtilTrunkFans;
//import org.lsst.ccs.subsystem.pathfinder.constants.UtilTrunkHeaters;
//import org.lsst.ccs.subsystem.pathfinder.constants.UtilTrunkValves;
//import org.lsst.ccs.subsystem.pathfinder.constants.ValveState;
//import org.lsst.ccs.subsystem.pathfinder.constants.VpcControlState;

/**
 *  Contains the state of the pathfinder subsystem
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class UtilTrunkState implements Serializable {
    
    public static final String KEY = "UtilTrunkState";

    private int tickMillis;        // Data status update period (ms)
    private final FanState[] fanState = new FanState[UtilTrunkFans.NUM_FANS];
    private final FanState[] fanBaseState = new FanState[UtilTrunkFans.NUM_FANS];
    private final double[] fanSpeed = new double[UtilTrunkFans.NUM_FANS];
    private final double[] deltaTemp = new double[UtilTrunkFans.NUM_FANS];
    //    private VpcControlState vpcState = VpcControlState.MANUAL;
    //    private final ValveState[] valveState = new ValveState[UtilTrunkValves.NUM_VALVES];
    //    private final ValveState[] valveBaseState = new ValveState[UtilTrunkValves.NUM_VALVES];
    //    private final double[] valvePosition = new double[UtilTrunkValves.NUM_VALVES];
    //    private final HeaterState[] heaterState = new HeaterState[UtilTrunkHeaters.NUM_HEATERS];
    //    private final HeaterState[] heaterBaseState = new HeaterState[UtilTrunkHeaters.NUM_HEATERS];
    //    private final double[] heaterValue = new double[UtilTrunkHeaters.NUM_HEATERS];
    
    public UtilTrunkState() {
        Arrays.fill(fanState, FanState.OFFLINE);
        Arrays.fill(fanBaseState, FanState.SPEED);
	//        Arrays.fill(valveState, ValveState.OFFLINE);
	//        Arrays.fill(valveBaseState, ValveState.SHUT);
	//        Arrays.fill(heaterState, HeaterState.OFFLINE);
	//        Arrays.fill(heaterBaseState, HeaterState.OFF);
    }
    
    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setFanState(int fan, FanState state) {
        fanState[fan] = state;
    }

    public FanState getFanState(int fan) {
        return fanState[fan];
    }

    public void setFanBaseState(int fan, FanState state) {
        fanBaseState[fan] = state;
    }

    public FanState getFanBaseState(int fan) {
        return fanBaseState[fan];
    }

    public void setFanSpeed(int fan, double speed) {
        fanSpeed[fan] = speed;
    }

    public double getFanSpeed(int fan) {
        return fanSpeed[fan];
    }
    /*
    public void setVpcState(VpcControlState state) {
        vpcState = state;
    }

    public VpcControlState getVpcState() {
        return vpcState;
    }
    */
    /*
    public void setValveState(int valve, ValveState state) {
        valveState[valve] = state;
    }

    public ValveState getValveState(int valve) {
        return valveState[valve];
    }

    public void setValveBaseState(int valve, ValveState state) {
        valveBaseState[valve] = state;
    }

    public ValveState getValveBaseState(int valve) {
        return valveBaseState[valve];
    }

    public void setValvePosition(int valve, double position) {
        valvePosition[valve] = position;
    }

    public double getValvePosition(int valve) {
        return valvePosition[valve];
    }
    */
    public void setDeltaTemp(int fan, double temp) {
        deltaTemp[fan] = temp;
    }

    public double getDeltaTemp(int fan) {
        return deltaTemp[fan];
    }
    /*
    public void setHeaterState(int htr, HeaterState state) {
        heaterState[htr] = state;
    }

    public HeaterState getHeaterState(int htr) {
        return heaterState[htr];
    }

    public void setHeaterBaseState(int htr, HeaterState state) {
        heaterBaseState[htr] = state;
    }

    public HeaterState getHeaterBaseState(int htr) {
        return heaterBaseState[htr];
    }

    public void setHeaterValue(int htr, double value) {
        heaterValue[htr] = value;
    }

    public double getHeaterValue(int htr) {
        return heaterValue[htr];
    }
    */

    private static final long serialVersionUID = 6776368107598365551L;
}
