package org.lsst.ccs.subsystem.pathfinder.alerts;

import org.lsst.ccs.bus.data.Alert;

/**
 * ComCam Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum PathfinderAlerts {


    // PLC Alerts

    VACUUM_PLC_NOT_ALIVE("VacuumPLCNotAlive", "Vacuum PLC not alive"),
    HX_VACUUM_BAD("HxVacuumBad", "HX Vacuum Bad"),
    HX_GATE_FORCED_SHUT("HxGateForcedShut", "HX Gate Valve Forced Shut"),
    HX_GATE_CANNOT_OPEN("HxGateCannotOpen", "HX Gate Valve Cannot Open"),
    HX_TURBO_PUMP_BAD("HxTurboPumpBad", "HX Turbo Pump Bad"),


    // Monitoring Alerts

    /**
     * Alert raised when the cryo plate temperature is too high.
     */
//    CRYO_PLATE_TEMPERATURE_TOO_HIGH("CryoPlateHighTemp","Alert for Cryo plate temperture too high"),
    /**
     * Alert raised when the cryo plate temperature is too low.
     */
//    CRYO_PLATE_TEMPERATURE_TOO_LOW("CryoPlateLowTemp","Alert for Cryo plate temperture too low"),
    /**
     * Alert raised when the cold plate temperature is too high.
     */
//    COLD_PLATE_TEMPERATURE_TOO_HIGH("ColdPlateHighTemp","Alert for Cold plate temperture too high"),
    /**
     * Alert raised when the cold plate temperature is too low.
     */
//    COLD_PLATE_TEMPERATURE_TOO_LOW("ColdPlateLowTemp","Alert for Cold plate temperture too low"),
    /**
     * Alert raised when the pressure is too low.
     */
    PRESSURE_TOO_LOW("PressureLow","Alert raised when the pressure too low"),
    /**
     * Alert raised when the pressure is too high.
     */
    PRESSURE_TOO_HIGH("PressureHigh","Alert raised when the pressure too high"),
    /**
     * Alert raised when the vacuum valve is shut off.
     */
    VACUUM_VALVE_SHUT_OFF("VacuumValveShutOff","Alert raised when the vacuum valve is shut off"),
    /**
     * Vacuum PLC is unresponsive
     */
    //    VACUUM_PLC_NOT_ALIVE("VacuumPLCNotAlive", "Vacuum PLC not alive"),
 
    /**
     * Alert raised when UPS goes onto battery.
     */
    UPS_ON_BATTERY("UPSOnBattery", "Alert raised when UPS goes onto battery"),
    /**
     * Alert raised when UPS becomes disconnected
     */
    UPS_DISCONNECTED("UPSDisconnected", "Alert raised when UPS becomes disconnected"),
    /**
     * Alert raised if TurboPump status shows pump failure
     */
    TURBO_PUMP_FAIL("TurboPumpFailure", "Alert raised when TurboPump status is Fail"),
    /**
     * Alert raised if TurboPump temperature is too high
     */
    TURBO_PUMP_OVERTEMP("TurboPumpOverTemp","Alert raised when TurboPump temperature is too high"), 
    /**
     * Alert raised if a load RTD temperature is too high
     */
    LOAD_RTD_OVERTEMP("LoadRTDTemp","Alert raised when a Load RTD temperature is too high"), 
    /**
     * Alert raised if max temp too high
     */
    TEMP_MAX_TOO_HIGH("PFTempHiMaxAlarm","Alert raised when the max temperature is too high"), 
    /**
     * Generic Alert.
     */
    GENERIC("GenericAlert","Generic Alert");
    
    
    private final String id, description;
    
    PathfinderAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }

    public String getDescription() {
        return description;
    }
    
    public Alert getAlert() {
        return getAlert(null);
    }
    
    //Is this needed?
    private Alert getAlert(String prefix) {
        String aId = null;
        if ( prefix != null && ! prefix.isEmpty() ) {
            aId = prefix+"/"+id;
        } else {
            aId = id;
        }
        return new Alert(aId,description);
    }
    
}
